declare class SceneManager {
    constructor();
    static _scene: Scene_Base | null;
    static _nextScene: Scene_Base | null;
    static _stack: (new () => Scene_Base)[];
    static _exiting: boolean;
    static _previousScene: Scene_Base | null;
    static _previousClass: Function | null;
    static _backgroundBitmap: Bitmap | null;
    static _smoothDeltaTime: number;
    static _elapsedTime: number;
    static run(sceneClass: new () => Scene_Base): void;
    static initialize(): void;
    static checkBrowser(): void;
    static checkPluginErrors(): void;
    static initGraphics(): void;
    static initAudio(): void;
    static initVideo(): void;
    static initInput(): void;
    static setupEventHandlers(): void;
    static update(deltaTime: number): void;
    static determineRepeatNumber(deltaTime: number): number;
    static terminate(): void;
    static onError(event: any): void;
    static onReject(event: {
        message: any;
        reason: any;
    }): void;
    static onUnload(): void;
    static onKeyDown(event: {
        ctrlKey: any;
        altKey: any;
        keyCode: any;
    }): void;
    static reloadGame(): void;
    static showDevTools(): void;
    static catchException(e: unknown): void;
    static catchNormalError(e: any): void;
    static catchLoadError(e: any[]): void;
    static catchUnknownError(e: any): void;
    static updateMain(): void;
    static updateFrameCount(): void;
    static updateInputData(): void;
    static updateEffekseer(): void;
    static changeScene(): void;
    static updateScene(): void;
    static isGameActive(): any;
    static onSceneTerminate(): void;
    static onSceneCreate(): void;
    static onBeforeSceneStart(): void;
    static onSceneStart(): void;
    static isSceneChanging(): boolean;
    static isCurrentSceneBusy(): boolean | null;
    static isNextScene(sceneClass: Function): boolean | null;
    static isPreviousScene(sceneClass: Function | null): boolean;
    static goto(sceneClass: (new () => Scene_Base) | null): void;
    static push(sceneClass: new () => Scene_Base): void;
    static pop(): void;
    static exit(): void;
    static clearStack(): void;
    static stop(): void;
    static prepareNextScene(...args: any[]): void;
    static snap(): Bitmap;
    static snapForBackground(): void;
    static backgroundBitmap(): Bitmap | null;
    static resume(): void;
}
