declare class Game_Actor extends Game_Battler {
    protected _level: number;
    protected _actorId: number;
    protected _name: string;
    protected _nickname: string;
    protected _classId: number;
    protected _characterName: string;
    protected _characterIndex: number;
    protected _faceName: string;
    protected _faceIndex: number;
    protected _battlerName: string;
    protected _exp: {
        [key: number]: number;
    };
    protected _skills: number[];
    protected _equips: Game_Item[];
    protected _actionInputIndex: number;
    protected _lastMenuSkill: Game_Item;
    protected _lastBattleSkill: Game_Item;
    protected _lastCommandSymbol: string | null;
    protected _profile: string;
    protected _stateSteps: {
        [key: number]: number;
    };
    get level(): number;
    constructor(actorId: number);
    initialize(actorId: number): void;
    initMembers(): void;
    setup(actorId: number): void;
    actorId(): number;
    actor(): RMMZData.Actor;
    name(): string;
    setName(name: string): void;
    nickname(): string;
    setNickname(nickname: string): void;
    profile(): string;
    setProfile(profile: string): void;
    characterName(): string;
    characterIndex(): number;
    faceName(): string;
    faceIndex(): number;
    battlerName(): string;
    clearStates(): void;
    eraseState(stateId: number): void;
    resetStateCounts(stateId: number): void;
    initImages(): void;
    expForLevel(level: number): number;
    initExp(): void;
    currentExp(): number;
    currentLevelExp(): number;
    nextLevelExp(): number;
    nextRequiredExp(): number;
    maxLevel(): number;
    isMaxLevel(): boolean;
    initSkills(): void;
    initEquips(equips: number[]): void;
    equipSlots(): number[];
    equips(): (RMMZData.Weapon | RMMZData.Armor)[];
    weapons(): RMMZData.Weapon[];
    armors(): RMMZData.Armor[];
    hasWeapon(weapon: RMMZData.Weapon): boolean;
    hasArmor(armor: RMMZData.Armor): boolean;
    isEquipChangeOk(slotId: number): boolean;
    changeEquip(slotId: number, item: RMMZData.Weapon | RMMZData.Armor | null): void;
    forceChangeEquip(slotId: number, item: RMMZData.Weapon | RMMZData.Armor): void;
    tradeItemWithParty(newItem: RMMZData.Weapon | RMMZData.Armor | null, oldItem: RMMZData.Weapon | RMMZData.Armor | null): boolean;
    changeEquipById(etypeId: number, itemId: number): void;
    isEquipped(item: ItemObject | null): boolean;
    discardEquip(item: ItemObject | null): void;
    releaseUnequippableItems(forcing: boolean): void;
    clearEquipments(): void;
    optimizeEquipments(): void;
    bestEquipItem(slotId: number): RMMZData.Weapon | null;
    calcEquipItemPerformance(item: {
        params: number[];
    }): number;
    isSkillWtypeOk(skill: RMMZData.Item): boolean;
    isWtypeEquipped(wtypeId: number): boolean;
    refresh(): void;
    hide(): void;
    isActor(): boolean;
    friendsUnit(): Game_Party;
    opponentsUnit(): Game_Troop;
    index(): number;
    isBattleMember(): boolean;
    isFormationChangeOk(): boolean;
    currentClass(): RMMZData.Class;
    isClass(gameClass: {
        id: number;
    }): boolean;
    skillTypes(): number[];
    skills(): RMMZData.Item[];
    usableSkills(): RMMZData.Item[];
    traitObjects(): {
        traits: RMMZData.Trait[];
    }[];
    attackElements(): number[];
    hasNoWeapons(): boolean;
    bareHandsElementId(): number;
    paramBase(paramId: number): number;
    paramPlus(paramId: number): number;
    attackAnimationId1(): number;
    attackAnimationId2(): number;
    bareHandsAnimationId(): number;
    changeExp(exp: number, show: boolean): void;
    levelUp(): void;
    levelDown(): void;
    findNewSkills(lastSkills: RMMZData.Item[]): RMMZData.Item[];
    displayLevelUp(newSkills: RMMZData.Item[]): void;
    gainExp(exp: number): void;
    finalExpRate(): number;
    benchMembersExpRate(): 1 | 0;
    shouldDisplayLevelUp(): boolean;
    changeLevel(level: number, show: boolean): void;
    learnSkill(skillId: number): void;
    forgetSkill(skillId: number): void;
    isLearnedSkill(skillId: number): boolean;
    hasSkill(skillId: number): boolean;
    changeClass(classId: number, keepExp: number): void;
    setCharacterImage(characterName: string, characterIndex: number): void;
    setFaceImage(faceName: string, faceIndex: number): void;
    setBattlerImage(battlerName: string): void;
    isSpriteVisible(): boolean;
    performActionStart(action: {
        isGuard: () => number;
    }): void;
    performAction(action: Game_Action): void;
    performActionEnd(): void;
    performAttack(): void;
    performDamage(): void;
    performEvasion(): void;
    performMagicEvasion(): void;
    performCounter(): void;
    performCollapse(): void;
    performVictory(): void;
    performEscape(): void;
    makeActionList(): Game_Action[];
    makeAutoBattleActions(): void;
    makeConfusionActions(): void;
    makeActions(): void;
    onPlayerWalk(): void;
    updateStateSteps(state: RMMZData.State): void;
    showAddedStates(): void;
    showRemovedStates(): void;
    stepsForTurn(): number;
    turnEndOnMap(): void;
    checkFloorEffect(): void;
    executeFloorDamage(): void;
    basicFloorDamage(): number;
    maxFloorDamage(): number;
    performMapDamage(): void;
    clearActions(): void;
    inputtingAction(): Game_Action;
    selectNextCommand(): boolean;
    selectPreviousCommand(): boolean;
    lastSkill(): RMMZData.Item;
    lastMenuSkill(): RMMZData.Item;
    setLastMenuSkill(skill: RMMZData.Item): void;
    lastBattleSkill(): RMMZData.Item;
    setLastBattleSkill(skill: RMMZData.Item): void;
    lastCommandSymbol(): string | null;
    setLastCommandSymbol(symbol: string | null): void;
    testEscape(item: RMMZData.Item): boolean;
    meetsUsableItemConditions(item: RMMZData.Item): boolean;
    onEscapeFailure(): void;
}
