declare abstract class Game_Battler extends Game_BattlerBase {
    protected _actions: Game_Action[];
    protected _speed: number;
    protected _result: Game_ActionResult;
    protected _actionState: string;
    protected _lastTargetIndex: number;
    protected _damagePopup: boolean;
    protected _effectType: string | null;
    protected _motionType: string | null;
    protected _weaponImageId: number;
    protected _motionRefresh: boolean;
    protected _selected: boolean;
    protected _tpbState: string;
    protected _tpbChargeTime: number;
    protected _tpbCastTime: number;
    protected _tpbIdleTime: number;
    protected _tpbTurnCount: number;
    protected _tpbTurnEnd: boolean;
    abstract isSpriteVisible(): boolean;
    abstract name(): string;
    abstract friendsUnit(): Game_Unit<Game_Battler>;
    abstract opponentsUnit(): Game_Unit<Game_Battler>;
    abstract index(): number;
    abstract isBattleMember(): boolean;
    initialize(...args: any[]): void;
    initMembers(): void;
    clearDamagePopup(): void;
    clearWeaponAnimation(): void;
    clearEffect(): void;
    clearMotion(): void;
    requestEffect(effectType: string): void;
    requestMotion(motionType: string): void;
    requestMotionRefresh(): void;
    cancelMotionRefresh(): void;
    select(): void;
    deselect(): void;
    isDamagePopupRequested(): boolean;
    isEffectRequested(): boolean;
    isMotionRequested(): boolean;
    isWeaponAnimationRequested(): boolean;
    isMotionRefreshRequested(): boolean;
    isSelected(): boolean;
    effectType(): string | null;
    motionType(): string | null;
    weaponImageId(): number;
    startDamagePopup(): void;
    shouldPopupDamage(): boolean;
    startWeaponAnimation(weaponImageId: number): void;
    action(index: number): Game_Action;
    setAction(index: number, action: Game_Action): void;
    numActions(): number;
    clearActions(): void;
    result(): Game_ActionResult;
    clearResult(): void;
    clearTpbChargeTime(): void;
    applyTpbPenalty(): void;
    initTpbChargeTime(advantageous?: any): void;
    tpbChargeTime(): number;
    startTpbCasting(): void;
    startTpbAction(): void;
    isTpbCharged(): boolean;
    isTpbReady(): boolean;
    isTpbTimeout(): boolean;
    updateTpb(): void;
    updateTpbChargeTime(): void;
    updateTpbCastTime(): void;
    updateTpbAutoBattle(): void;
    updateTpbIdleTime(): void;
    tpbAcceleration(): number;
    tpbRelativeSpeed(): number;
    tpbSpeed(): number;
    tpbBaseSpeed(): number;
    tpbRequiredCastTime(): number;
    onTpbCharged(): void;
    shouldDelayTpbCharge(): boolean;
    finishTpbCharge(): void;
    isTpbTurnEnd(): boolean;
    initTpbTurn(): void;
    startTpbTurn(): void;
    makeTpbActions(): void;
    onTpbTimeout(): void;
    turnCount(): number;
    canInput(): boolean;
    refresh(): void;
    addState(stateId: number): void;
    isStateAddable(stateId: number): boolean;
    isStateRestrict(stateId: number): boolean;
    onRestrict(): void;
    removeState(stateId: number): void;
    escape(): void;
    addBuff(paramId: number, turns: number): void;
    addDebuff(paramId: number, turns: number): void;
    removeBuff(paramId: number): void;
    removeBattleStates(): void;
    removeAllBuffs(): void;
    removeStatesAuto(timing: number): void;
    removeBuffsAuto(): void;
    removeStatesByDamage(): void;
    makeActionTimes(): any;
    makeActions(): void;
    speed(): number;
    makeSpeed(): void;
    currentAction(): Game_Action;
    removeCurrentAction(): void;
    setLastTarget(target: Game_Battler): void;
    forceAction(skillId: number, targetIndex: number): void;
    useItem(item: RMMZData.Item): void;
    consumeItem(item: any): void;
    gainHp(value: number): void;
    gainMp(value: number): void;
    gainTp(value: number): void;
    gainSilentTp(value: number): void;
    initTp(): void;
    clearTp(): void;
    chargeTpByDamage(damageRate: number): void;
    regenerateHp(): void;
    maxSlipDamage(): number;
    regenerateMp(): void;
    regenerateTp(): void;
    regenerateAll(): void;
    onBattleStart(advantageous?: any): void;
    onAllActionsEnd(): void;
    onTurnEnd(): void;
    onBattleEnd(): void;
    onDamage(value: number): void;
    setActionState(actionState: string): void;
    isUndecided(): boolean;
    isInputting(): boolean;
    isWaiting(): boolean;
    isActing(): boolean;
    isChanting(): boolean;
    isGuardWaiting(): boolean;
    performActionStart(action: {
        isGuard: () => any;
    }): void;
    performAction(action: Game_Action): void;
    performActionEnd(): void;
    performDamage(): void;
    performMiss(): void;
    performRecovery(): void;
    performEvasion(): void;
    performMagicEvasion(): void;
    performCounter(): void;
    performReflection(): void;
    performSubstitute(target: Game_Battler): void;
    performCollapse(): void;
}
