declare abstract class Game_BattlerBase {
    protected _hp: number;
    protected _tp: number;
    protected _mp: number;
    protected _hidden: boolean;
    protected _paramPlus: number[];
    protected _states: any[];
    protected _stateTurns: any;
    protected _buffs: number[];
    protected _buffTurns: number[];
    constructor(...args: any[]);
    static TRAIT_ELEMENT_RATE: number;
    static TRAIT_DEBUFF_RATE: number;
    static TRAIT_STATE_RATE: number;
    static TRAIT_STATE_RESIST: number;
    static TRAIT_PARAM: number;
    static TRAIT_XPARAM: number;
    static TRAIT_SPARAM: number;
    static TRAIT_ATTACK_ELEMENT: number;
    static TRAIT_ATTACK_STATE: number;
    static TRAIT_ATTACK_SPEED: number;
    static TRAIT_ATTACK_TIMES: number;
    static TRAIT_ATTACK_SKILL: number;
    static TRAIT_STYPE_ADD: number;
    static TRAIT_STYPE_SEAL: number;
    static TRAIT_SKILL_ADD: number;
    static TRAIT_SKILL_SEAL: number;
    static TRAIT_EQUIP_WTYPE: number;
    static TRAIT_EQUIP_ATYPE: number;
    static TRAIT_EQUIP_LOCK: number;
    static TRAIT_EQUIP_SEAL: number;
    static TRAIT_SLOT_TYPE: number;
    static TRAIT_ACTION_PLUS: number;
    static TRAIT_SPECIAL_FLAG: number;
    static TRAIT_COLLAPSE_TYPE: number;
    static TRAIT_PARTY_ABILITY: number;
    static FLAG_ID_AUTO_BATTLE: number;
    static FLAG_ID_GUARD: number;
    static FLAG_ID_SUBSTITUTE: number;
    static FLAG_ID_PRESERVE_TP: number;
    static ICON_BUFF_START: number;
    static ICON_DEBUFF_START: number;
    get hp(): number;
    get mp(): number;
    get tp(): number;
    get mhp(): number;
    get mmp(): number;
    get atk(): number;
    get def(): number;
    get mat(): number;
    get mdf(): number;
    get agi(): number;
    get luk(): number;
    get hit(): any;
    get eva(): any;
    get cri(): any;
    get cev(): any;
    get mev(): any;
    get mrf(): any;
    get cnt(): any;
    get hrg(): any;
    get mrg(): any;
    get trg(): any;
    get tgr(): number;
    get grd(): number;
    get rec(): number;
    get pha(): number;
    get mcr(): number;
    get tcr(): number;
    get pdr(): number;
    get mdr(): number;
    get fdr(): number;
    get exr(): number;
    initialize(...args: any[]): void;
    initMembers(): void;
    clearParamPlus(): void;
    clearStates(): void;
    eraseState(stateId: number): void;
    isStateAffected(stateId: number): boolean;
    isDeathStateAffected(): boolean;
    deathStateId(): number;
    resetStateCounts(stateId: number): void;
    isStateExpired(stateId: number): boolean;
    updateStateTurns(): void;
    clearBuffs(): void;
    eraseBuff(paramId: number): void;
    buffLength(): number;
    buff(paramId: number): number;
    isBuffAffected(paramId: number): boolean;
    isDebuffAffected(paramId: number): boolean;
    isBuffOrDebuffAffected(paramId: number): boolean;
    isMaxBuffAffected(paramId: number): boolean;
    isMaxDebuffAffected(paramId: number): boolean;
    increaseBuff(paramId: number): void;
    decreaseBuff(paramId: number): void;
    overwriteBuffTurns(paramId: number, turns: number): void;
    isBuffExpired(paramId: number): boolean;
    updateBuffTurns(): void;
    die(): void;
    revive(): void;
    states(): RMMZData.State[];
    stateIcons(): number[];
    buffIcons(): number[];
    buffIconIndex(buffLevel: number, paramId: number): number;
    allIcons(): number[];
    traitObjects(): {
        traits: RMMZData.Trait[];
    }[];
    allTraits(): RMMZData.Trait[];
    traits(code: number): RMMZData.Trait[];
    traitsWithId(code: any, id: number): RMMZData.Trait[];
    traitsPi(code: number, id: number): number;
    traitsSum(code: number, id: number): any;
    traitsSumAll(code: number): any;
    traitsSet(code: number): number[];
    paramBase(paramId: number): number;
    paramPlus(paramId: number): number;
    paramBasePlus(paramId: number): number;
    paramMin(paramId: number): 1 | 0;
    paramMax(paramId: number): number;
    paramRate(paramId: number): number;
    paramBuffRate(paramId: number): number;
    param(paramId: number): number;
    xparam(xparamId: number): any;
    sparam(sparamId: number): number;
    elementRate(elementId: number): number;
    debuffRate(paramId: number): number;
    stateRate(stateId: number): number;
    stateResistSet(): number[];
    isStateResist(stateId: number): boolean;
    attackElements(): number[];
    attackStates(): number[];
    attackStatesRate(stateId: number): any;
    attackSpeed(): any;
    attackTimesAdd(): number;
    attackSkillId(): number;
    addedSkillTypes(): number[];
    isSkillTypeSealed(stypeId: number): boolean;
    addedSkills(): number[];
    isSkillSealed(skillId: number): boolean;
    isEquipWtypeOk(wtypeId: number): boolean;
    isEquipAtypeOk(atypeId: number): boolean;
    isEquipTypeLocked(etypeId: number): boolean;
    isEquipTypeSealed(etypeId: number): boolean;
    slotType(): number;
    isDualWield(): boolean;
    actionPlusSet(): any[];
    specialFlag(flagId: number): boolean;
    collapseType(): number;
    partyAbility(abilityId: number): boolean;
    isAutoBattle(): boolean;
    isGuard(): boolean;
    isSubstitute(): boolean;
    isPreserveTp(): boolean;
    addParam(paramId: number, value: number): void;
    setHp(hp: number): void;
    setMp(mp: number): void;
    setTp(tp: number): void;
    maxTp(): number;
    refresh(): void;
    recoverAll(): void;
    hpRate(): number;
    mpRate(): number;
    tpRate(): number;
    hide(): void;
    appear(): void;
    isHidden(): boolean;
    isAppeared(): boolean;
    isDead(): boolean;
    isAlive(): boolean;
    isDying(): boolean;
    isRestricted(): boolean;
    canInput(): boolean;
    canMove(): boolean;
    isConfused(): boolean;
    confusionLevel(): number;
    isActor(): boolean;
    isEnemy(): boolean;
    sortStates(): void;
    restriction(): number;
    addNewState(stateId: number): void;
    onRestrict(): void;
    mostImportantStateText(): string;
    stateMotionIndex(): number;
    stateOverlayIndex(): number;
    isSkillWtypeOk(skill: RMMZData.Item): boolean;
    skillMpCost(skill: RMMZData.Item): number;
    skillTpCost(skill: RMMZData.Item): number;
    canPaySkillCost(skill: RMMZData.Item): boolean;
    paySkillCost(skill: RMMZData.Item): void;
    isOccasionOk(item: RMMZData.Item): boolean;
    meetsUsableItemConditions(item: RMMZData.Item): boolean;
    meetsSkillConditions(skill: RMMZData.Item): boolean;
    meetsItemConditions(item: RMMZData.Item): boolean;
    canUse(item: RMMZData.Item): boolean;
    canEquip(item: ItemObject): boolean;
    canEquipWeapon(item: any): boolean;
    canEquipArmor(item: any): boolean;
    guardSkillId(): number;
    canAttack(): boolean;
    canGuard(): boolean;
}
