declare class Game_Party extends Game_Unit<Game_Actor> {
    static ABILITY_ENCOUNTER_HALF: number;
    static ABILITY_ENCOUNTER_NONE: number;
    static ABILITY_CANCEL_SURPRISE: number;
    static ABILITY_RAISE_PREEMPTIVE: number;
    static ABILITY_GOLD_DOUBLE: number;
    static ABILITY_DROP_ITEM_DOUBLE: number;
    protected _gold: number;
    protected _steps: number;
    protected _lastItem: Game_Item;
    protected _menuActorId: number;
    protected _targetActorId: number;
    protected _actors: number[];
    protected _items: {
        [key: number]: number;
    };
    protected _weapons: {
        [key: number]: number;
    };
    protected _armors: {
        [key: number]: number;
    };
    initialize(): void;
    initAllItems(): void;
    exists(): boolean;
    size(): number;
    isEmpty(): boolean;
    members(): Game_Actor[];
    allMembers(): Game_Actor[];
    battleMembers(): Game_Actor[];
    hiddenBattleMembers(): Game_Actor[];
    allBattleMembers(): Game_Actor[];
    maxBattleMembers(): number;
    leader(): Game_Actor;
    removeInvalidMembers(): void;
    reviveBattleMembers(): void;
    items(): RMMZData.Item[];
    weapons(): RMMZData.Weapon[];
    armors(): RMMZData.Armor[];
    equipItems(): RMMZData.Weapon[];
    allItems(): RMMZData.Item[];
    itemContainer(item: ItemObject | null): {
        [key: number]: number;
    } | null;
    setupStartingMembers(): void;
    name(): string;
    setupBattleTest(): void;
    setupBattleTestMembers(): void;
    setupBattleTestItems(): void;
    highestLevel(): number;
    addActor(actorId: number): void;
    removeActor(actorId: number): void;
    gold(): number;
    gainGold(amount: number): void;
    loseGold(amount: number): void;
    maxGold(): number;
    steps(): number;
    increaseSteps(): void;
    numItems(item: ItemObject | null): number;
    maxItems(item: ItemObject | null): number;
    hasMaxItems(item: ItemObject): boolean;
    hasItem(item: ItemObject | null, includeEquip?: boolean): boolean;
    isAnyMemberEquipped(item: ItemObject | null): boolean;
    gainItem(item: ItemObject | null, amount: number, includeEquip?: boolean): void;
    discardMembersEquip(item: ItemObject | null, amount: number): void;
    loseItem(item: ItemObject | null, amount: number, includeEquip?: boolean): void;
    consumeItem(item: ItemObject): void;
    canUse(item: RMMZData.Item): boolean;
    canInput(): boolean;
    isAllDead(): boolean;
    isEscaped(): boolean;
    onPlayerWalk(): void;
    menuActor(): Game_Actor | null;
    setMenuActor(actor: Game_Actor): void;
    makeMenuActorNext(): void;
    makeMenuActorPrevious(): void;
    targetActor(): Game_Actor | null;
    setTargetActor(actor: Game_Actor): void;
    lastItem(): ItemObject | null;
    setLastItem(item: ItemObject): void;
    swapOrder(index1: number, index2: number): void;
    charactersForSavefile(): (string | number)[][];
    facesForSavefile(): (string | number)[][];
    partyAbility(abilityId: number): boolean;
    hasEncounterHalf(): boolean;
    hasEncounterNone(): boolean;
    hasCancelSurprise(): boolean;
    hasRaisePreemptive(): boolean;
    hasGoldDouble(): boolean;
    hasDropItemDouble(): boolean;
    ratePreemptive(troopAgi: number): number;
    rateSurprise(troopAgi: number): number;
    performVictory(): void;
    performEscape(): void;
    removeBattleStates(): void;
    requestMotionRefresh(): void;
    onEscapeFailure(): void;
}
