declare class Game_Picture {
    protected _name: string;
    protected _origin: Point;
    protected _x: number;
    protected _y: number;
    protected _scaleX: number;
    protected _scaleY: number;
    protected _opacity: number;
    protected _blendMode: number;
    protected _tone: ToneType | null;
    protected _angle: number;
    protected _targetX: number;
    protected _targetY: number;
    protected _targetScaleX: number;
    protected _targetScaleY: number;
    protected _targetOpacity: number;
    protected _duration: number;
    protected _wholeDuration: number;
    protected _easingType: number;
    protected _easingExponent: number;
    protected _toneTarget: ToneType | null;
    protected _toneDuration: number;
    protected _rotationSpeed: number;
    constructor(...args: any[]);
    initialize(): void;
    name(): string;
    origin(): Point;
    x(): number;
    y(): number;
    scaleX(): number;
    scaleY(): number;
    opacity(): number;
    blendMode(): number;
    tone(): ToneType | null;
    angle(): number;
    initBasic(): void;
    initTarget(): void;
    initTone(): void;
    initRotation(): void;
    show(name: string, origin: Point, x: number, y: number, scaleX: number, scaleY: number, opacity: number, blendMode: number): void;
    move(origin: Point, x: number, y: number, scaleX: number, scaleY: number, opacity: number, blendMode: number, duration: number, easingType: number): void;
    rotate(speed: number): void;
    tint(tone: ToneType, duration: number): void;
    update(): void;
    updateMove(): void;
    updateTone(): void;
    updateRotation(): void;
    applyEasing(current: number, target: number): number;
    calcEasing(t: number): number;
    easeIn(t: number, exponent: number): number;
    easeOut(t: number, exponent: number): number;
    easeInOut(t: number, exponent: number): number;
}
