declare class Game_System {
    protected _saveEnabled: boolean;
    protected _menuEnabled: boolean;
    protected _encounterEnabled: boolean;
    protected _formationEnabled: boolean;
    protected _battleCount: number;
    protected _winCount: number;
    protected _escapeCount: number;
    protected _saveCount: number;
    protected _versionId: number;
    protected _savefileId: number;
    protected _framesOnSave: number;
    protected _bgmOnSave: IAudioObject | null;
    protected _bgsOnSave: IAudioObject | null;
    protected _windowTone: ToneType | null;
    protected _battleBgm: IAudioObject | null;
    protected _victoryMe: IAudioObject | null;
    protected _defeatMe: IAudioObject | null;
    protected _savedBgm: IAudioObject | null;
    protected _walkingBgm: IAudioObject | null;
    constructor(...args: any[]);
    initialize(): void;
    isJapanese(): RegExpMatchArray | null;
    isChinese(): RegExpMatchArray | null;
    isKorean(): RegExpMatchArray | null;
    isCJK(): RegExpMatchArray | null;
    isRussian(): RegExpMatchArray | null;
    isSideView(): boolean;
    isAutosaveEnabled(): boolean;
    isSaveEnabled(): boolean;
    disableSave(): void;
    enableSave(): void;
    isMenuEnabled(): boolean;
    disableMenu(): void;
    enableMenu(): void;
    isEncounterEnabled(): boolean;
    disableEncounter(): void;
    enableEncounter(): void;
    isFormationEnabled(): boolean;
    disableFormation(): void;
    enableFormation(): void;
    battleCount(): number;
    winCount(): number;
    escapeCount(): number;
    saveCount(): number;
    versionId(): number;
    savefileId(): number;
    setSavefileId(savefileId: number): void;
    windowTone(): ToneType;
    setWindowTone(value: ToneType): void;
    battleBgm(): {
        name: string;
        pan: number;
        pitch: number;
        volume: number;
    } | IAudioObject;
    setBattleBgm(value: IAudioObject): void;
    victoryMe(): {
        name: string;
        pan: number;
        pitch: number;
        volume: number;
    } | IAudioObject;
    setVictoryMe(value: IAudioObject): void;
    defeatMe(): {
        name: string;
        pan: number;
        pitch: number;
        volume: number;
    } | IAudioObject;
    setDefeatMe(value: IAudioObject): void;
    onBattleStart(): void;
    onBattleWin(): void;
    onBattleEscape(): void;
    onBeforeSave(): void;
    onAfterLoad(): void;
    playtime(): number;
    playtimeText(): string;
    saveBgm(): void;
    replayBgm(): void;
    saveWalkingBgm(): void;
    replayWalkingBgm(): void;
    saveWalkingBgm2(): void;
    mainFontFace(): string;
    numberFontFace(): string;
    mainFontSize(): number;
    windowPadding(): number;
    windowOpacity(): number;
}
