/*:
 * @target MZ
 * @plugindesc 影表示プラグイン最適化パッチ（unagiootoro氏プラグイン用／アクティブイベント＋プレイヤー＋負荷軽減）
 * @help
 * ・$gameMap.getActiveEvents() に基づき影対象を限定（マップID:60）
 * ・プレイヤー（$gamePlayer）は常に影対象
 * ・透明キャラ／画像なしキャラの影を非表示
 * ・Sprite_Shadow の update を前回状態キャッシュ付きで早期 return
 */

(() => {
    const TARGET_MAP_ID = 60;
    const ACTIVE_RANGE = 30;
    const UPDATE_INTERVAL = 2;

    let _frameCount = 0;

    // 論理処理：_activeEvents を更新し、レンジ内イベントのみ update()
    const _Game_Map_updateEvents = Game_Map.prototype.updateEvents;
    Game_Map.prototype.updateEvents = function() {
        $gameVariables._data[251] = 0;

        if (this.mapId() === TARGET_MAP_ID) {
            _frameCount++;

            if (_frameCount % UPDATE_INTERVAL === 0) {
                const playerX = $gamePlayer.x;
                const playerY = $gamePlayer.y;

                this._activeEvents = this.events().filter(event => {
                    const dx = Math.abs(event.x - playerX);
                    const dy = Math.abs(event.y - playerY);
                    return dx <= ACTIVE_RANGE && dy <= ACTIVE_RANGE;
                });
            }

            for (const event of this._activeEvents) {
                event.update();
                $gameVariables._data[251]++;
            }
        } else {
            for (const event of this.events()) {
                event.update();
                $gameVariables._data[251]++;
            }
        }

        for (const commonEvent of this._commonEvents) {
            commonEvent.update();
        }
    };

    // 描画スプライト：レンジ外のイベントは Sprite_Character の更新をスキップし、非表示にする
    const _Sprite_Character_update = Sprite_Character.prototype.update;
    Sprite_Character.prototype.update = function() {
        const c = this._character;

        if (
            $gameMap.mapId() === TARGET_MAP_ID &&
            c instanceof Game_Event &&
            !$gameMap._activeEvents?.includes(c)
        ) {
            this.visible = false; // 非表示にして描画も抑制
            return;
        }

        this.visible = true;
        _Sprite_Character_update.call(this);
    };

    // 影スプライトの update もレンジ外はスキップ＆非表示
    const _Sprite_Shadow_update = SimpleShadow.Sprite_Shadow.prototype.update;
    SimpleShadow.Sprite_Shadow.prototype.update = function() {
        const c = this._character;

        if (
            $gameMap.mapId() === TARGET_MAP_ID &&
            c instanceof Game_Event &&
            !$gameMap._activeEvents?.includes(c)
        ) {
            this.visible = false;
            return;
        }

        this.visible = true;
        _Sprite_Shadow_update.call(this);
    };
})();








