(function() {
    // 元のイベント削除処理を拡張
    const _Game_PrefabEvent_erase = Game_PrefabEvent.prototype.erase;
    Game_PrefabEvent.prototype.erase = function() {
        // イベント削除時のエミッタークリア処理
        const eventId = this._eventId;

        // $gameMap.particleEmitters が存在する場合に処理
        if ($gameMap.particleEmitters) {
            for (const key in $gameMap.particleEmitters) {
                // エミッターIDが `-[eventId]` を含む場合に削除
                if (key.endsWith(`-${eventId}`)) {
                    const emitter = $gameMap.particleEmitters[key];
                    if (emitter) {
                        emitter.clear(); // エミッター停止
                        delete $gameMap.particleEmitters[key]; // 管理リストから削除
                    }
                }
            }
        }

        // 元の削除処理を呼び出す
        _Game_PrefabEvent_erase.call(this);
    };
})();
