//==========================================================================
// EliMZ_JumpSystem_DotMovePatch.js
//==========================================================================

/*:
@target MZ
@base EliMZ_JumpSystem
@orderAfter EliMZ_JumpSystem

@plugindesc v1.0.0 - Dot Move System (unagi ootoro) Compatibility patch.
@author Hakuen Studio
@url https://hakuenstudio.itch.io/eli-jump-system-for-rpg-maker-mv

@help
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
If you like my work, please consider supporting me on Patreon!
https://www.patreon.com/hakuenstudio
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
============================================================================
Features
============================================================================

● Compatibility patch that let EliMZ Jump System and Dot Move System from 
unagi ootoro, Pixel Movement plugin work together.

============================================================================
How to use
============================================================================

Download Dot Move System:
https://raw.githubusercontent.com/unagiootoro/RPGMZ/master/DotMoveSystem.js
https://raw.githubusercontent.com/unagiootoro/RPGMZ/master/DotMoveSystem_FunctionEx.js

Dot Move System must be above EliMZ_Book.
This plugin must be below EliMZ_JumpSystem.

It's Plug and Play.

============================================================================
Terms of Use
============================================================================

Follow the credits of unagi ootoro too!
https://raw.githubusercontent.com/unagiootoro/RPGMZ/master/DotMoveSystem.js
https://raw.githubusercontent.com/unagiootoro/RPGMZ/master/DotMoveSystem_FunctionEx.js

https://www.hakuenstudio.com/rpg-maker/terms-of-use

============================================================================
Links
============================================================================

Facebook - https://www.facebook.com/hakuenstudio
Instagram - https://www.instagram.com/hakuenstudio
Twitter - https://twitter.com/hakuen_studio

============================================================================
Update log
============================================================================
Version 1.0.0 - 12/19/2021
- Plugin release!

*/

"use strict"

var Eli = Eli || {}
var Imported = Imported || {}
Imported.Eli_JumpSystem_DotMovePatch = true

/* ========================================================================== */
/*                                    ALERT                                   */
/* ========================================================================== */

{

    const installWarning = `You must have installed the EliMZ_Book plugin above all Eli plugins.
Please download it for free.`
    const pluginName = (() => {
        const srcScript = document.currentScript.src
        const start = srcScript.lastIndexOf("/") + 1
        const end = srcScript.lastIndexOf(".js")
        const pluginName = srcScript.substring(start, end)

        return pluginName
    })()
    const requiredVersion = ['4','1','4']
    const updateWarning = `${pluginName} needs the EliMZ_Book ${requiredVersion} version.
Please download it for free.`

    function callEliBook(){
        window.open('https://hakuenstudio.itch.io/')
    }
    
    function needInstallBook() {
        if(!Eli.alert){

            if(window.confirm(installWarning)) callEliBook()
            Eli.alert = true
        }
    }

    function needUpdateBook() {
        if(!Eli.alert){

            if(window.confirm(updateWarning)) callEliBook()
            Eli.alert = true
        }
    }
    
    if(!Imported.Eli_Book) needInstallBook()
    if(Eli.Book.Version < requiredVersion) needUpdateBook()
     
}

/* ========================================================================== */
/*                                   PLUGIN                                   */
/* ========================================================================== */

{

Eli.JumpSystem_DotMovePatch = {

    parameters: {},
    alias: {},

    initialize(){
        this.initParameters()
        this.initPluginCommands()
    },

    initParameters(){
        this.parameters = Eli.PluginManager.createParameters()
    },

    initPluginCommands(){
        const commands = []
        Eli.PluginManager.registerCommands(this, commands)
    },

    param(){
        return this.parameters
    },
    
}

const Plugin = Eli.JumpSystem_DotMovePatch
const Alias = Eli.JumpSystem_DotMovePatch.alias
const DotMoveSystem_FunctionEx = $plugins.some(item => item.name === "DotMoveSystem_FunctionEx")

/* ----------------------------- DOT MOVE SYSTEM ---------------------------- */
{

/* ------------------------------- GAME PLAYER ------------------------------ */
{

Alias.Game_Player_moveByInput = Game_Player.prototype.moveByInput
Game_Player.prototype.moveByInput = function() {
    if(this.isJumping()) return
    Alias.Game_Player_moveByInput.call(this)
}

/*
    The function isMoving do not return true if Game_Player is moving by input.
    So, I believe you need to add to it the "this.isMoved()" too.
*/

Alias.Game_Player_isMoving = Game_Player.prototype.isMoving
Game_Player.prototype.isMoving = function() {
    return Alias.Game_Player_isMoving.call(this) || this.isMoved()//&& (this.getInputDirection() > 0)
}

}

}


/* ------------------------ DOTMOVESYSTEM_FUNCTIONEX ------------------------ */
if(DotMoveSystem_FunctionEx){

/* --------------------------- GAME CHARACTER BASE -------------------------- */
{

Game_CharacterBase.prototype.isSmartJumping = function() {
    return false
}

}

}

}