// ============================================================================
// FixStarPriority.js
// ----------------------------------------------------------------------------
// Copyright (c) 2017 DERIVE <derive.nobody.jp>
// This software is released under the MIT License.
// https://opensource.org/licenses/MIT
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2017-07-04 初版
// ============================================================================

/*:
 * @plugindesc 星タイル優先度調整プラグイン
 * @author DERIVE
 * @help キャラが星タイルより上に表示されるか下に表示されるかを自動調整します。
 */

(function() {
    'use strict';

    // ========================================================================
    // Game_Map
    // ========================================================================

    Game_Map.prototype.checkLayeredTilesStarFlags = function(x, y, bit) {
        var flags = this.tilesetFlags();
        return this.layeredTiles(x, y).some(function(tileId) {
            var flag = flags[tileId];
            return flag === 16 ? 0 : (flag & bit) !== 0;
        });
    };

    Game_Map.prototype.isStar = function(x, y) {
        return this.isValid(x, y)
            && this.checkLayeredTilesStarFlags(x, y, 0x10);
    };

    // ========================================================================
    // Game_CharacterBase
    // ========================================================================

    var _Game_CharacterBase_initMembers
        = Game_CharacterBase.prototype.initMembers;

    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBase_initMembers.apply(this, arguments);
        this._priorityFix = false;
    };

    Game_CharacterBase.prototype.isOnStar = function() {
        var x1 = Math.floor(this._realX); // modified
        var x2 = Math.ceil(this._realX); // modified
        var y1 = Math.floor(this._realY); // modified
        var y2 = Math.ceil(this._realY); // modified
        var y3 = Math.floor(this._realY-0.5); // modified
        var y4 = Math.ceil(this._realY-0.5); // modified

        // modified
        if (this.prJump) {
            y = Math.round(this._realY + this.prJumpHeight);
        }
        //
        return $gameMap.isStar(x1, y1) || $gameMap.isStar(x2, y1) || $gameMap.isStar(x1, y2) || $gameMap.isStar(x2, y2)
            || $gameMap.isStar(x1, y3) || $gameMap.isStar(x2, y3) || $gameMap.isStar(x1, y4) || $gameMap.isStar(x2, y4) // modified
    };

    Game_CharacterBase.prototype.updatePriority = function() {
        if (this._priorityFix === this.isOnStar()) return;
        this._priorityFix = this.isOnStar();
        //console.log('onStar:'+this._priorityFix);
        /*
        if (this.isOnStar()) {
            this.startOpacity(10,120);
        } else {
            this.startOpacity(10,255);
        }
        */
    };

    var _Game_CharacterBase_update
        = Game_CharacterBase.prototype.update;

    Game_CharacterBase.prototype.update = function() {
        _Game_CharacterBase_update.apply(this, arguments);
        this.updatePriority();
    };

    // overwrite
    Game_CharacterBase.prototype.screenZ = function() {
        var n = this._priorityFix ? 1 : 2;
        return this._priorityType * 2 + n;
    };

})();
