/*:
 * @target MZ
 * @plugindesc 浮いているキャラクターの通行判定をメモタグで管理し、水場や穴を通過可能にします。
 * @help
 * イベントのメモ欄に <isFloating> タグを追加することで、
 * そのイベントが浮いていると判定し、水場や穴のタイルを通過できるようにします。
 * 
 * 例:
 * <isFloating>
 * 
 * タイルセットのタイルに適切なタイルタグを設定してください。
 * 
 * タイルタグ:
 * 水場/穴: タイルタグ 2
 */

(() => {
    // オリジナルのcanPassメソッドを保存
    const _Game_CharacterBase_canPass = Game_CharacterBase.prototype.canPass;
    //const _Game_Player_canPass = Game_Player.prototype.canPass;

    // 通行判定のオーバーライド
    Game_CharacterBase.prototype.canPass = function(x, y, d) {
        //y = y % 0.5 == 0 ? y : y-0.5;
        const x2 = $gameMap.roundXWithDirection(x, d);
        const y2 = $gameMap.roundYWithDirection(y, d);

        // キャラクターがイベントであり、かつ浮いている場合の通行判定
        if (this.isEvent()) {
            if (this.isFloating()) {
                if (this.isFloatPassable(x2, y2, d, false)) {
                    return true;
                }
                return false;
            }
        } else {
            if ($gamePlayer.isFloating()) {
                if ($gamePlayer.isFloatPassable(x2, y2, d, true)) {
                    return true;
                }
                return false;
            }
        }

        // 通常の通行判定
        return _Game_CharacterBase_canPass.call(this, x, y, d);
    };

    /*
    Game_Player.prototype.canPass = function(x, y, d) {
        //y = y % 0.5 == 0 ? y : y-0.5;
        const x2 = $gameMap.roundXWithDirection(x, d);
        const y2 = $gameMap.roundYWithDirection(y, d);

        if ($gamePlayer.isFloating()) {
            if ($gamePlayer.isFloatPassable(x2, y2, d, true)) {
                //$gameMap.spawnEvent(Game_Interpreter.prototype.getEventIdForEventReSpawn('マークA', true),x,y,true);
                return true;
            }
            //$gameMap.spawnEvent(Game_Interpreter.prototype.getEventIdForEventReSpawn('マークB', true),x,y,true);
            return false;
        }

        // 通常の通行判定
        return _Game_Player_canPass.call(this, x, y, d);
    };
    */

    // キャラクターの位置に応じた通行判定スクリプト
    let floatCorrectionArr = {
        'base2': {'x':    0, 'y': -0.5},
        'base4': {'x':  0.5, 'y':    0},
        'base6': {'x': -0.5, 'y':    0},
        'base8': {'x':    0, 'y':  0.5},
        'add2':  {'x':    0, 'y':    0},
        'add4':  {'x':    0, 'y':    0},
        'add6':  {'x':    0, 'y':    0},
        'add8':  {'x':    0, 'y': -0.5},
        'addadd2':  {'x':    0, 'y':    0},
        'addadd4':  {'x':    0, 'y':    0},
        'addadd6':  {'x':  0.5, 'y':    0},
        'addadd8':  {'x':    0, 'y':    0},
    }
    window.floatCorrectionArr = floatCorrectionArr;

    Game_CharacterBase.prototype.isFloatPassable = function(x, y, d, isPlayer) {
        //y = y % 0.5 == 0 ? y : y-0.5;
        ///*
            switch (d) {
                case 2: x += floatCorrectionArr.base2.x; y += floatCorrectionArr.base2.y; break;
                case 4: x += floatCorrectionArr.base4.x; y += floatCorrectionArr.base4.y; break;
                case 6: x += floatCorrectionArr.base6.x; y += floatCorrectionArr.base6.y; break;
                case 8: x += floatCorrectionArr.base8.x; y += floatCorrectionArr.base8.y; break;
            }
        //*/
        
        //y = y % 0.5 == 0 ? y : y-0.5;
        const x2 = $gameMap.roundXWithDirection(x, d);
        const y2 = $gameMap.roundYWithDirection(y, d);
        this.isCollidedWithCharacters(x2, y2);

        /*
        switch (d) {
            case 2: x += floatCorrectionArr.add2.x; y += floatCorrectionArr.add2.y; break;
            case 4: x += floatCorrectionArr.add4.x; y += floatCorrectionArr.add4.y; break;
            case 6: x += floatCorrectionArr.add6.x; y += floatCorrectionArr.add6.y; break;
            case 8: x += floatCorrectionArr.add8.x; y += floatCorrectionArr.add8.y; break;
        }

        const x3 = $gameMap.roundXWithDirection(x, d);
        const y3 = $gameMap.roundYWithDirection(y, d);

        switch (d) {
            case 2: x += floatCorrectionArr.addadd2.x; y += floatCorrectionArr.addadd2.y; break;
            case 4: x += floatCorrectionArr.addadd4.x; y += floatCorrectionArr.addadd4.y; break;
            case 6: x += floatCorrectionArr.addadd6.x; y += floatCorrectionArr.addadd6.y; break;
            case 8: x += floatCorrectionArr.addadd8.x; y += floatCorrectionArr.addadd8.y; break;
        }

        const x4 = $gameMap.roundXWithDirection(x, d);
        const y4 = $gameMap.roundYWithDirection(y, d);
        */

        /*
        // 通行可能タイル (例: 水場/穴)
        if (($gameMap.isFloatUnpassableTile(x2, y2, d, isPlayer))
            || ($gameMap.isFloatUnpassableTile(x3, y3, d, isPlayer))
            || ($gameMap.isFloatUnpassableTile(x4, y4, d, isPlayer))
            ) {
            return false;
        } else {
            if (($gameMap.isFloatPassableTile(x2, y2, d, isPlayer)) || ($gameMap.isFloatPassableTile(x3, y3, d, isPlayer))) {
                return true;
            }
        }
        */
       
        // 通行可能タイル (例: 水場/穴)
        if (
                //($gameMap.isFloatUnpassableTile(Math.floor(x2), Math.floor(y2), d, isPlayer))
            //|| ($gameMap.isFloatUnpassableTile(Math.ceil(x2), Math.floor(y2), d, isPlayer))
             ($gameMap.isFloatUnpassableTile(Math.floor(x2), Math.ceil(y2), d, isPlayer))
            || ($gameMap.isFloatUnpassableTile(Math.ceil(x2), Math.ceil(y2), d, isPlayer))
            ) {
            return false;
        } else {
            if (
                    //($gameMap.isFloatPassableTile(Math.floor(x2), Math.floor(y2), d, isPlayer))
                //|| ($gameMap.isFloatPassableTile(Math.ceil(x2), Math.floor(y2), d, isPlayer))
                 ($gameMap.isFloatPassableTile(Math.floor(x2), Math.ceil(y2), d, isPlayer))
                || ($gameMap.isFloatPassableTile(Math.ceil(x2), Math.ceil(y2), d, isPlayer))
                ) {
                return true;
            }
        }

        // デフォルトの通行判定
        return _Game_CharacterBase_canPass.call(this, x, y, d);
    };

    // キャラクターがイベントかどうかを判定する関数
    Game_CharacterBase.prototype.isEvent = function() {
        return this instanceof Game_Event;
    };

    // イベントが浮いているかどうかを判定する関数
    Game_Event.prototype.isFloating = function() {
        return !!this.event().meta.isFloating;
    };

    // プレイヤーが浮いているかどうかを判定する関数
    Game_Player.prototype.isFloating = function() {
        return $gamePlayer._isFloating;
    };

    // マップ設定用にタイル判定を追加
    Game_Map.prototype.isFloatPassableTile = function(x, y, d, isPlayer) {
        if (isPlayer) {
            return (this.terrainTag(x, y) === 2 || (this.terrainTag(x, y-0.5) === 2 ) || (d === 8 && this.terrainTag(x, y+0.5) === 2))
                    || ((d === 2) && (this.terrainTag(x, y) === 1 || this.terrainTag(x, y-0.5) === 1))
                    || ((d === 8) && (this.terrainTag(x, y) === 1 || this.terrainTag(x, y+0.5) === 1));

        } else {
            return (this.terrainTag(x, y) === 2 || (this.terrainTag(x, y-0.5) === 2 ) || (d === 8 && this.terrainTag(x, y+0.5) === 2))
                    || ((d === 2) && (this.terrainTag(x, y) === 1 || this.terrainTag(x, y-0.5) === 1))
        }
    };

    Game_Map.prototype.isFloatUnpassableTile = function(x, y, d, isPlayer) {
        if (isPlayer) {
            return this.terrainTag(x, y) === 3
                    || ((d === 4 || d === 6) && (this.terrainTag(x, y) === 1));
        } else {
            return this.terrainTag(x, y) === 3
                    || ((d === 4 || d === 6) && (this.terrainTag(x, y) === 1))
                    //|| (d === 8 && (this.terrainTag(x, y+1) === 1))
                    //|| (this.regionId(x, y) === 90);
        }
    };


})();
