/*:
 * @target MZ
 * @plugindesc Adjusts icon size in messages to match the font size, ensuring no extra space around icons.
 * @help This plugin adjusts the size of icons in message windows to match the current font size and removes extra spacing around them.
 * 
 * No plugin commands.
 */

(() => {
    const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    
    Window_Base.prototype.processEscapeCharacter = function(code, textState) {
        switch (code) {
            case 'I':
                this.processDrawIcon(this.obtainEscapeParam(textState), textState);
                break;
            default:
                _Window_Base_processEscapeCharacter.call(this, code, textState);
                break;
        }
    };

    Window_Base.prototype.processDrawIcon = function(iconIndex, textState) {
        const iconSize = this.contents.fontSize;
        const x = textState.x + (this.lineHeight() - iconSize) / 2;
        const y = textState.y + (this.lineHeight() - iconSize) / 2;
        this.drawIcon(iconIndex, x, y, iconSize, iconSize);
        textState.x += iconSize + 4; // Adjust the spacing as needed
    };

    Window_Base.prototype.drawIcon = function(iconIndex, x, y, width, height) {
        const bitmap = ImageManager.loadSystem('IconSet');
        const pw = ImageManager.iconWidth;
        const ph = ImageManager.iconHeight;
        const sx = iconIndex % 16 * pw;
        const sy = Math.floor(iconIndex / 16) * ph;
        this.contents.blt(bitmap, sx, sy, pw, ph, x, y, width, height);
    };
})();
