/*:
 * @target MZ
 * @plugindesc Adjusts icon size and height to match text font size in message window.
 * @help This plugin adjusts the size of icons and height to match the font size of text in
 * the message window, ensuring a balanced display.
 * 
 * No plugin commands.
 */

(() => {
    const _Window_Message_processEscapeCharacter = Window_Message.prototype.processEscapeCharacter;
    Window_Message.prototype.processEscapeCharacter = function(code, textState) {
        switch (code) {
            case 'I':
                this.processDrawIcon(this.obtainEscapeParam(textState), textState);
                break;
            default:
                _Window_Message_processEscapeCharacter.call(this, code, textState);
                break;
        }
    };

    Window_Message.prototype.processDrawIcon = function(iconIndex, textState) {
        const lineHeight = this.lineHeight();
        const iconSize = lineHeight - 8; // Adjust the icon size as needed
        const y = textState.y + (lineHeight - iconSize) / 2;
        this.drawIcon(iconIndex, textState.x, y);
        textState.x += iconSize + 4; // Adjust the spacing as needed
    };

    const _Window_Base_drawIcon = Window_Base.prototype.drawIcon;
    Window_Base.prototype.drawIcon = function(iconIndex, x, y) {
        const textState = this.dummyTextState();
        const fontSize = textState.fontSize;
        const iconSize = Math.min(fontSize + 4, ImageManager.iconWidth); // Adjust icon size based on font size
        const iconY = y + (textState.height - 4 - iconSize) / 2; // Adjust icon position based on text height
        this.drawIconAdjusted(iconIndex, x, iconY, iconSize);
    };

    Window_Base.prototype.drawIconAdjusted = function(iconIndex, x, y, size) {
        const bitmap = ImageManager.loadSystem('IconSet');
        const pw = ImageManager.iconWidth;
        const ph = ImageManager.iconHeight;
        const sx = iconIndex % 16 * pw;
        const sy = Math.floor(iconIndex / 16) * ph;
        this.contents.blt(bitmap, sx, sy, pw, ph, x, y, size, size);
    };

    Window_Base.prototype.dummyTextState = function() {
        const textState = {
            index: 0,
            x: 0,
            y: 0,
            left: 0,
            text: '',
            height: this.lineHeight(),
            fontSize: this.contents.fontSize
        };
        return textState;
    };
})();
