/*:
 * @plugindesc MultilingualRapper - プラグインのラップと多言語サポートを追加します
 * @help
 * このプラグインは既存のプラグインをラップし、\LANGF[battle_1_01] 制御文字を用いた多言語サポートを追加します。
 */

(function() {
    // 元のプラグインの設定に合わせたJSONファイルの読み込み
    function loadJsonData(fileName) {
        const xhr = new XMLHttpRequest();
        const url = 'data/' + fileName;
        xhr.open('GET', url, false);  // 同期的に読み込む
        xhr.overrideMimeType('application/json');
        xhr.send();
        if (xhr.status === 200) {
            return JSON.parse(xhr.responseText);
        }
        console.error('Failed to load JSON file: ' + url);
        return null;
    }

    // 言語に応じたJSONデータの読み込み
    const languageData = loadJsonData('msg_' + ConfigManager.language + '.json');

    function processLangF(text) {
        return text.replace(/\\LANGF\[(.*?)\]/gi, function(match, key) {
            return languageData[key] || match;
        });
    }

    // オリジナルのプラグイン関数をラッピング
    const originalFunctions = {};

    // 例として、Window_BaseのdrawTextをラップする
    originalFunctions.Window_Base_drawText = Window_Base.prototype.drawText;
    Window_Base.prototype.drawText = function(text, x, y, maxWidth, align) {
        text = processLangF(text);
        originalFunctions.Window_Base_drawText.call(this, text, x, y, maxWidth, align);
    };

    // 他の必要なプラグイン関数も同様にラップしてください
    // 例: 
    // originalFunctions.SomePluginFunction = SomePlugin.someFunction;
    // SomePlugin.someFunction = function(arg1, arg2) {
    //     // 必要な前処理
    //     arg1 = processLangF(arg1);
    //     // オリジナル関数の呼び出し
    //     return originalFunctions.SomePluginFunction.call(this, arg1, arg2);
    // };

})();
