/*:
 * @target MZ
 * @plugindesc [動作確認済] NRP_MapTravel 確認ウィンドウ追加パッチ（はい／いいえ）
 * @author ChatGPT
 */

(function() {
  if (typeof Scene_SelectSpots === "undefined") {
    console.error("このパッチは NRP_MapTravel.js の後に読み込んでください。");
    return;
  }

  // Yes/No 確認ウィンドウ
  class Window_ConfirmPrompt extends Window_Command {
    constructor(message, callback) {
      const w = 300;
      const h = Window_Command.prototype.fittingHeight(3);
      const x = (Graphics.boxWidth - w) / 2;
      const y = (Graphics.boxHeight - h) / 2;
      super(new Rectangle(x, y, w, h));

      this._message = message;
      this._callback = callback;
      this.select(1);
      this.openness = 0;
      this.open();
    }

    makeCommandList() {
      this.addCommand("はい", "yes");
      this.addCommand("いいえ", "no");
    }

    drawItem(index) {
      const rect = this.itemLineRect(index);
      this.resetTextColor();
      this.drawText(this.commandName(index), rect.x, rect.y, rect.width, "center");
    }

    paint() {
      super.paint();
      this.drawTextEx(this._message, this.textPadding(), 0);
    }

    itemRect(index) {
      const rect = super.itemRect(index);
      rect.y += this.lineHeight();
      return rect;
    }
  }

  const _onOk = Scene_SelectSpots.prototype.onSpotSelectOk;

  Scene_SelectSpots.prototype.onSpotSelectOk = function() {
    const spot = this._selectWindow.item();
    if (!spot) return;

    const name = spot.SpotName || "この地点";
    const message = `${name} に移動しますか？`;

    const confirmWindow = new Window_ConfirmPrompt(message, result => {
      this.removeChild(confirmWindow);
      if (result === "yes") {
        _onOk.call(this); // 元の移動処理へ
      } else {
        this._selectWindow.activate(); // 戻る
      }
    });

    confirmWindow.setHandler("yes", () => {
      confirmWindow._callback("yes");
    });
    confirmWindow.setHandler("no", () => {
      confirmWindow._callback("no");
    });

    this.addWindow(confirmWindow);
    confirmWindow.activate();
  };
})();
