// NoButtonArea.js Ver.1.1.0
// MIT License (C) 2022 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc ボタンエリアを確保しません。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/494375691.html
* @help ボタンエリアを除去し、ボタンの不透明度を下げることで
* 画面表示領域を目一杯にします。
*
* [更新履歴]
* 2022/12/03：Ver.1.0.0　公開。
* 2023/04/05：Ver.1.0.1　仮想ボタンのタップがウィンドウに干渉する不具合を修正。
* 2023/04/08：Ver.1.1.0　仮想ボタンのタップがウィンドウに一切干渉しないよう修正。
*
*/

'use strict';

{
	//-----------------------------------------------------------------------------
	// Scene_MenuBase

	Scene_MenuBase.prototype.buttonAreaBottom = function() {
		return 0;
	};

	Scene_MenuBase.prototype.mainAreaHeight = function() {
		return Graphics.boxHeight - this.helpAreaHeight();
	};

	//-----------------------------------------------------------------------------
	// Sprite_Button

	Sprite_Button.prototype.updateOpacity = function() {
		this.opacity = this._pressed ? 224 : 160;
	};

	//-----------------------------------------------------------------------------
	// Window_Selectable

	const _Window_Selectable_hitIndex = Window_Selectable.prototype.hitIndex;
	Window_Selectable.prototype.hitIndex = function() {
		const index = _Window_Selectable_hitIndex.call(this);
		if (index === -1 || this.isOverlappingButton()) {
			return -1;
		}
		return index;
	};

	Window_Selectable.prototype.isOverlappingButton = function() {
		return ConfigManager.touchUI && SceneManager._scene._windowLayer.children.some(sprite => {
			if (sprite._isWindow || !sprite.isBeingTouched) {
				return false;
			}
			return sprite.isClickEnabled() && sprite.isBeingTouched();
		});
	};

}