//=============================================================================
// PRTN_AbsCore.js - Last modified 2021/12/17
//=============================================================================

/*:
* @plugindesc ARPG用の機能を実装するセット
* @target MZ
* @author Perutan（けんせい）
* @url http://twitter.com/kensei1203
*
* @param 非ダメージ時アニメーションID
* @desc ダメージが通らなかったときに表示するアニメーションID
* @type animation
* @default 16
*
* @param ヒット時アニメーションID
* @desc 攻撃が通ったときに表示するアニメーションID
* @type animation
* @default 6
*
* @param 強ヒット時アニメーションID
* @desc クリティカルや弱点攻撃が通ったときに表示するアニメーションID
* @type animation
* @default 6
*
* @param 攻撃ダメージ値用変数ID
* @desc 算出されたダメージを格納する変数のID
* @type variable
* @default 98
*
* @param 被ダメージ値用変数ID
* @desc 算出されたダメージを格納する変数のID
* @type variable
* @default 10
*
* @param 被ダメージスイッチID
* @desc 被ダメージ時にONにするスイッチのID
* @type switch
* @default 84
*
* @param 攻撃属性引き渡し用変数ID
* @desc 攻撃時の属性を格納する変数のID
* @type variable
* @default 69
*
* @param 対象者イベントID用変数ID
* @desc 攻撃対象のイベントIDを格納する変数のID
* @type variable
* @default 7
*
* @param ザコダメージコモンイベントID
* @desc ザコ敵に攻撃が当たったときに呼び出すコモンイベントのID
* @type common_event
* @default 0
*
* @param 攻撃判定無効用スイッチID
* @desc 攻撃判定を無効にするためのスイッチのID
* @type switch
* @default 9
*
* @param 敵撃破時オンにするセルフスイッチ
* @desc 敵撃破時オンにするセルフスイッチ
* @type string
* @default B
*
*
* @help
*
*
*
*/

(function () {
  'use strict'

  //=============================================================================
  // プラグインパラメータの取得
  //=============================================================================
  var pluginName = 'PRTN_AbsCore';
  var parameters = PluginManager.parameters('PRTN_AbsCore');
  var noDamageAnimId = Number(parameters['非ダメージ時アニメーションID']);
  var hitDamageAnimId = Number(parameters['ヒット時アニメーションID']);
  var criDamageAnimId = Number(parameters['強ヒット時アニメーションID']);
  var dealDamageVarId = Number(parameters['攻撃ダメージ値用変数ID']);
  var sufferDamageVarId = Number(parameters['被ダメージ値用変数ID']);
  var sufferDamageSwiId = Number(parameters['被ダメージスイッチID']);
  var targetEidVarId = Number(parameters['対象者イベントID用変数ID']);
  var zCommonEventId = Number(parameters['ザコダメージコモンイベントID']);
  var noHitSwiId = Number(parameters['攻撃判定無効用スイッチID']);
  var attributeVarId = Number(parameters['攻撃属性引き渡し用変数ID']);
  var selfSwitchByDefeat = String(parameters['敵撃破時オンにするセルフスイッチ']);


  //=============================================================================
  // Game_CharacterBase
  //=============================================================================
  var _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
  Game_CharacterBase.prototype.initMembers = function () {
    _Game_CharacterBase_initMembers.apply(this, arguments);
    this.ABSinvincible = false;
    this.ABSdefeated = false;
    this._ABSstatePts ={
      'poison'  : 0,
      'stun'    : 0,
      'silence' : 0,
    };
  };

  //=============================================================================
  // Game_Event
  //=============================================================================
  var _Game_Event_initialize = Game_Event.prototype.initialize;
  Game_Event.prototype.initialize = function (mapId, eventId) {
    _Game_Event_initialize.apply(this, arguments);
    this._battler = this.event().meta.ABSenemy > 0 ? new Game_Enemy(this.event().meta.ABSenemy) : null;
    if (this.event().meta.ABSaffect) {
      this.ABSaffect = this.event().meta.ABSaffect.split(',');
      this.ABSaffectType = Number(this.ABSaffect[0]);
      this.ABSaffectValue = Number(this.ABSaffect[1]);
    }
  };

  //=============================================================================
  // Game_Interpreter
  //=============================================================================

  // プラグインコマンドの定義

  // for MZ
  /*
  const script = document.currentScript;
  const param = PluginManagerEx.createParameter(script);

  PluginManagerEx.registerCommand(script, 'GetCollision', function(args) {
    var argsMV = [args.width, args.height, args.offsetX, args.offsetY, args.skillId, args.indiv, args.magnification];
    this.getCollision(argsMV);
  });

  PluginManagerEx.registerCommand(script, 'StartDealDamage', function(args) {
    var argsMV = [args.targetId, args.indiv, args.magnification];
    this.startDealDamage(argsMV);
  });

  PluginManagerEx.registerCommand(script, 'StartSufferDamage', function(args) {
    this.startSufferDamage(args);
  });
  */

  // for MV
  var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function (command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    //console.log(command+' '+args);

    // 攻撃判定　コマンド定義
    if (command === 'GetCollision') {
      this.getCollision(args);
    };

    // 攻撃ダメージ処理　コマンド定義
    if (command === 'StartDealDamage') {
      this.startDealDamage(args);
    };

    // 被ダメージ処理　コマンド定義
    if (command === 'StartSufferDamage') {
      this.startSufferDamage(args);
    };
  };

  //=============================================================================
  // マップ敵のセルフスイッチとライフを初期化
  const _Game_Player_reserveTransfer      = Game_Player.prototype.reserveTransfer;
  Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
      _Game_Player_reserveTransfer.apply(this, arguments);
      //Game_Interpreter.prototype.setupPrBattleParameter();
  };

  Game_Interpreter.prototype.setupPrBattleParameter = function () {
    for (var eventID = 1; eventID <= 999; eventID++) {
      var mapID = this._mapId;
      if (!$dataMap.events[eventID]) continue;

      /*
      if (!$gameMap.event(eventID).event().meta.ABSatOnce
      && ($gameMap.event(eventID).event().meta.ABSenemy > 0
      || $gameMap.event(eventID).event().meta.ABSweed
      || $gameMap.event(eventID).event().meta.ABSbonfire
      || $gameMap.event(eventID).event().meta.ABSkick
      || $gameMap.event(eventID).event().meta.ABSobject
      || $gameMap.event(eventID).event().meta.ABSobjectC)) {
      */
      if (!$gameMap.event(eventID).event().meta.ABSatOnce) {
        $gameSelfSwitches.setValue([mapID, eventID, "A"], false);
        $gameSelfSwitches.setValue([mapID, eventID, "B"], false);
        $gameSelfSwitches.setValue([mapID, eventID, "C"], false);
        $gameSelfSwitches.setValue([mapID, eventID, "D"], false);
        if ($gameMap.event(eventID)._battler) $gameMap.event(eventID)._battler._hp = $gameMap.event(eventID)._battler.mhp;
        $gameMap.event(eventID).ABSdefeated = false;
        $gameMap.event(eventID)._erased = false;
      }
    }
  };

  //=============================================================================
  // 攻撃判定
  Game_Interpreter.prototype.getCollision = function (args) {
    var collidWidth = Number(args[0]);
    var collidHeight = Number(args[1]);
    var shiftX = Number(args[2]);
    var shiftY = Number(args[3]);
    var attribute = Number(args[4] || 1);
    var indiv = Number(args[5] || -1);
    var partyMember = Number(args[6] || 0);
    var magnification = Number(args[7] || 1);
    var enemyOnly = Boolean(args[8] || false);
    //console.log(args);

    if (indiv === 0) {
      indiv = this.eventId();
    }

    //console.log("indiv: "+indiv);

    if ($gameSwitches.value(noHitSwiId)) return;

    var targetId = $gameMap.eventIdsInDistance(collidWidth, collidHeight, shiftX, shiftY, indiv);
    //console.log("targetIDs: "+targetId);

    for (var i = 0; i < targetId.length; i++) {
      var target = targetId[i];
      var targetCharacter = $gameMap.event(target);
      //console.log('check');

      if (enemyOnly) {
        if (targetCharacter.event().meta.ABSenemy > 0 && !targetCharacter.event().meta.ABSinvincible) {
          //console.log("damageDealing: "+target);
          $gameVariables._data[targetEidVarId] = target;
          $gameVariables._data[attributeVarId] = attribute;
          this.startDealDamage(target, indiv, magnification, partyMember);
          //this._interpreter = new Game_Interpreter();
          //if (zCommonEventId) $gameMap.event(target)._interpreter.setup($dataCommonEvents[zCommonEventId].list, target);
        }  
      } else {
        if (targetCharacter.event().meta.ABSweed) {
          //console.log("weedBreaking: "+target);
          var key = [$gameMap.mapId(), target, selfSwitchByDefeat];
          $gameSelfSwitches.setValue([key],true);
          $gameMap.event(key[1]).refresh();
          targetCharacter.ABSdefeated = true;
          continue;
        }
  
        if (!targetCharacter.event().meta.ABSinvincible) {
          //console.log("damageDealing: "+target);
          $gameVariables._data[targetEidVarId] = target;
          $gameVariables._data[attributeVarId] = attribute;
          this.startDealDamage(target, indiv, magnification, partyMember);
          //this._interpreter = new Game_Interpreter();
          //if (zCommonEventId) $gameMap.event(target)._interpreter.setup($dataCommonEvents[zCommonEventId].list, target);
        }  
      }
    }
  };

  //=============================================================================
  // 攻撃ダメージ処理
  Game_Interpreter.prototype.startDealDamage = function (targetId, indiv, magnification, partyMember) {
    var target = this.character(targetId)._eventId;
    var ev = $gameMap.event(target);
    var attribute = $gameVariables._data[attributeVarId];
    var damageResult = this.arpgMakeDamegeValue(target, attribute, partyMember);
    var dealDamage = damageResult[0];
    var criSuccess = damageResult[1];
    var hitWeakPoint = damageResult[2];
    var ogrizeAttacks = [10,11,15,16];

    if (!ev.ABSencountered && $gameSwitches.value(13) === false) dealDamage += dealDamage; // s[13]ボスゲージ表示中は不意打ち無効
    //if (ev._battler.mat > 0 && $gameParty.leader().isStateAffected(3) === false) dealDamage /= 10; // 悪神の加護があり、鬼神憑依していないとき
    if (ev._battler.mat > 0 && ogrizeAttacks.includes(attribute) === false) dealDamage *= 0.0001; // 悪神の加護があり、鬼神憑依攻撃でないとき
    ev._battler._hp -= dealDamage;
    $gameVariables._data[dealDamageVarId] = dealDamage;

    // CharacterPopupDamage
    //ev.startDamagePopup(dealDamage, false, false, false);

    var mhp = ev._battler.mhp;
    var hp = ev._battler._hp;
    if (hp > mhp) hp = mhp;

    if (hp / mhp < 0.25) {
      ev._tone = [80, 10, 0, 100];
    }

    if (hitDamageAnimId > 0) {
      if (dealDamage > 0) {
        if (hitWeakPoint || criSuccess) {
          $gameTemp.requestAnimation([ev], criDamageAnimId);
        } else {
          $gameTemp.requestAnimation([ev], hitDamageAnimId);
        }
      }
    }
    if (noDamageAnimId > 0) {
      if (dealDamage <= 0) {
        $gameTemp.requestAnimation([ev], noDamageAnimId);
      }
    }

    if (!ev.event().meta.ABSweed) {
      //if (zCommonEventId) this.setupChild($dataCommonEvents[zCommonEventId].list, target);
      if (ev._battler._hp <= 0) {
        var key = [$gameMap.mapId(), target, selfSwitchByDefeat];
        $gameSelfSwitches._data[key] = true;
        $gameMap.event(key[1]).refresh();
        ev.ABSdefeated = true;
        ev._interpreter = new Game_Interpreter();
        if (zCommonEventId) ev._interpreter.setup($dataCommonEvents[zCommonEventId].list, target);
      } else {
      //ev._interpreter = new Game_Interpreter();
      if (zCommonEventId) ev._interpreter.setupChild($dataCommonEvents[zCommonEventId].list, target);  
      }
    }
  };


  // 被ダメージ処理　処理内容
  Game_Interpreter.prototype.startSufferDamage = function (args) {
    var eId = args[0];
    var attribute = args[1];
    var partyMember = args[2];
    //var attribute = $gameVariables._data[attributeVarId];
    var sufferDamage = this.arpgSufferDamegeValue(eId, attribute, partyMember);
    $gameVariables._data[sufferDamageVarId] = sufferDamage[0];
    $gameSwitches.setValue(sufferDamageSwiId, true)
  };

  //=============================================================================
  // 攻撃ダメージ計算用の関数を定義
  Game_Interpreter.prototype.arpgMakeDamegeValue = function (eId, attribute, partyMember) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (partyMember === undefined) {
      partyMember = 0;
    }
    if (attribute === undefined) {
      var atkSkillId = 1; //通常攻撃
    } else {
      var atkSkillId = attribute; //特殊攻撃 = スキルID
    }

    var followersDamageRate = 0.8;
    var actor = $gameActors.actor($gameParty._actors[partyMember]);
    //var actor = $gameActors.actor(partyMember);
    var memberActorIds = [];
    memberActorIds = $gameParty.members().map((obj) => {
      return obj._actorId;
    });
    var order = memberActorIds.indexOf(actor._actorId);
    var enemy = $gameMap.event(eId)._battler;

    //console.log(actor, enemy, atkSkillId);
    var damageResult = this.arpgCalcDamage(actor, enemy, atkSkillId, eId);
    if (order > 0) damageResult[0] = Math.floor(damageResult[0] * followersDamageRate);
    $gameVariables._data[dealDamageVarId] = damageResult[0];
    console.log(damageResult);
    return damageResult;
  };

  // 被ダメージ計算用の関数を定義
  Game_Interpreter.prototype.arpgSufferDamegeValue = function (eId, attribute, partyMember) {
    if (!eId) {
      eId = this.eventId();
    }
    if (!partyMember) {
      partyMember = 0;
    }
    if (!attribute) {
      var atkSkillId = 1; //通常攻撃
    } else {
      var atkSkillId = attribute; //特殊攻撃 = スキルID
    }

    var followersDamageRate = 0.8;
    var actor = $gameActors.actor($gameParty._actors[partyMember]);
    var memberActorIds = [];
    memberActorIds = $gameParty.members().map((obj) => {
      return obj._actorId;
    });
    var order = memberActorIds.indexOf(actor._actorId);
    var enemy = $gameMap.event(eId)._battler;

    //console.log(enemy, actor, atkSkillId);
    var damageResult = this.arpgCalcDamage(enemy, actor, atkSkillId, eId);
    if (order > 0) damageResult[0] = Math.floor(damageResult[0] * followersDamageRate);
    return damageResult;
  };

  // ダメージ計算
  /*
  const _Game_Action_setSubject = Game_Action.prototype.setSubject;
  Game_Action.prototype.setSubject = function (subject) {
    if (SceneManager._scene.constructor !== Scene_Map) {
      _Game_Action_setSubject.apply(this, arguments);
    } else {
      if (subject.isActor()) {
        this._subjectActorId = subject.actorId();
        this._subjectEnemyIndex = -1;
      } else {
        this._subjectEnemyIndex = subject;
        this._subjectActorId = 0;
      }
    }
  };

  const _Game_Action_subject = Game_Action.prototype.subject;
  Game_Action.prototype.subject = function () {
    if (SceneManager._scene.constructor !== Scene_Map) {
      _Game_Action_subject.apply(this, arguments);
    } else {
      if (this._subjectActorId > 0) {
        return $gameActors.actor(this._subjectActorId);
      } else {
        return this._subjectEnemyIndex;
      }
    }
  };
  */

  Game_Interpreter.prototype.arpgCalcDamage = function (attacker, blocker, atkSkillId, eId) {
    var act = new Game_Action(attacker);
    if (attacker.isActor()) {
      $gameTroop._enemies = [blocker];
      act._subjectActorId = attacker.actorId();
      act._subjectEnemyIndex = -1;
    } else {
      $gameTroop._enemies = [attacker];
      act._subjectEnemyIndex = 0;
      act._subjectActorId = 0;
    }
    act.setSkill(atkSkillId);
    //console.log(act);
    //console.log(act.subject());
    //console.log(act.item());
    //console.log(blocker);
    var result = act.makeDamageValue(blocker);
    var atkCritical = $dataSkills[atkSkillId].damage.critical;
    var atkCriticalRate = attacker.xparam(2);
    if (atkCritical) {
      var criJudge = Math.floor(Math.random() * 100);
      var criSuccess = criJudge < atkCriticalRate * 100 ? true : false;
      if (criSuccess) {
        result *= 3;
      }
    }
    var damageResult = [result > 0 ? Math.round(result) : 0, criSuccess];
    return damageResult;
  };

  Game_Interpreter.prototype.arpgCalcDamage2 = function (attacker, blocker, atkSkillId, eId) {
    var a = attacker;
    var b = blocker;

    //スキルの各種情報を取得
    var n = atkSkillId;
    var atkCritical = $dataSkills[n].damage.critical; //boolean
    var atkElementId = $dataSkills[n].damage.elementId;
    var atkFormula = $dataSkills[n].damage.formula;
    var atkType = $dataSkills[n].damage.type;
    var atkVariance = $dataSkills[n].damage.variance;
    var atkMpCost = $dataSkills[n].mpCost;
    var atkName = $dataSkills[n].name;
    var atkTpCost = $dataSkills[n].tpCost;
    var atkTpGain = $dataSkills[n].tpGain;
    var atkCriticalRate = a.xparam(2);

    //通常攻撃の場合、装備中の武器の属性を適用
      var equipWpnId = a._equips[0] ? a._equips[0]._itemId : 0;
      if (equipWpnId > 0) {
        for (var i = 0; i < $dataWeapons[equipWpnId].traits.length; i++) {
          if ($dataWeapons[equipWpnId].traits[i].code === 31) {
            atkElementId = $dataWeapons[equipWpnId].traits[i].dataId;
          }
        }  
      }

    //計算
    var result = Math.ceil(eval(atkFormula));

    var hitWeakPoint = false;
    //防御側の属性有効度チェック
      var defElementsRateArr = blocker.traits;
      for (var i = 0; i < defElementsRateArr.length; i++) {
        if (defElementsRateArr[i].code === 11) {
          var defElementsRateId = defElementsRateArr[i].dataId;
          if (defElementsRateId === atkElementId) {
            result = result * defElementsRateArr[i].value;
            if (defElementsRateArr[i].value > 1) {
              hitWeakPoint = true;
            }
          }
        }
      }  

    //分散度適用
    var amp = Math.floor(Math.max(Math.abs(result) * atkVariance / 100, 0));
    var v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;
    result = result >= 0 ? result + v : result - v;

    //クリティカル判定
    if (atkCritical) {
      var criJudge = Math.floor(Math.random() * 100);
      var criSuccess = criJudge < atkCriticalRate * 100 ? true : false;
      if (criSuccess) {
        result *= 3;
      }
    }

    var damageResult = [result > 0 ? Math.round(result) : 0, criSuccess, hitWeakPoint];

    $gameVariables._data[dealDamageVarId] = damageResult[0];

    return damageResult;
  };

  //=============================================================================
  // 指定したイベントに紐付けられたエネミーの各種パラメータを取得する関数を定義
  //=============================================================================

  //------------------------------------------------------------------------------
  // 名前
  Game_Interpreter.prototype.eventName = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    return $dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].name || 0;
  };

  //------------------------------------------------------------------------------
  // 最大HP
  Game_Interpreter.prototype.eventHp = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[0] * ((rankRate * (rankRate / 100)) / 100)) || 0;
  };

  //------------------------------------------------------------------------------
  // 最大MP
  Game_Interpreter.prototype.eventMp = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[1] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 攻撃力
  Game_Interpreter.prototype.eventAtk = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[2] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 防御力
  Game_Interpreter.prototype.eventDef = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    //
    rankRate = 100;
    //
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[3] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 魔法力
  Game_Interpreter.prototype.eventMat = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[4] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 魔法防御
  Game_Interpreter.prototype.eventMdf = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    //
    rankRate = 100;
    //    
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[5] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 俊敏性
  Game_Interpreter.prototype.eventAgi = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[6] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 運
  Game_Interpreter.prototype.eventLuk = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].params[7] * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 経験値
  Game_Interpreter.prototype.eventExp = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].exp * rankRate / 100) || 0;
  };

  //------------------------------------------------------------------------------
  // 所持金
  Game_Interpreter.prototype.eventGold = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId)) return;
    var rankRate = 100;
    if ($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].meta.ABSrankUp) {
      var rankRate = rankRateVarId > 0 ? $gameVariables.value(rankRateVarId) : 100;
    }
    return Math.round($dataEnemies[Number($gameMap.event(eId).event().meta.ABSenemy)].gold) || 0;
  };

  //=============================================================================
  // イベントとプレイヤーの距離を取得する関数を定義
  //=============================================================================

  Game_Interpreter.prototype.eventDist = function (eId, directionShift) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    if (!$gameMap.event(eId).isNearTheScreen()) {
      return Infinity;
    }

    if (directionShift === undefined) {
      directionShift = 0;
    }

    var direction = this.character(eId)._direction;
    switch (direction) {
      case 2:
        var shiftX = 0;
        var shiftY = directionShift;
        break;
      case 4:
        var shiftX = directionShift * -1;
        var shiftY = 0;
        break;
      case 6:
        var shiftX = directionShift;
        var shiftY = 0;
        break;
      case 8:
        var shiftX = 0;
        var shiftY = directionShift * -1;
        break;
    }

    var realDeltaX = this.character(-1)._realX - (this.character(eId)._realX + shiftX);
    var realDeltaY = this.character(-1)._realY - (this.character(eId)._realY + shiftY);
    return Math.sqrt(Math.pow(realDeltaX, 2) + Math.pow(realDeltaY, 2));
  };

  //=============================================================================
  // イベント同士の距離を取得する関数を定義
  //=============================================================================

  Game_Interpreter.prototype.eventToEventDist = function (eId1, eId2) {
    if (eId1 === undefined) {
      eId1 = this.eventId();
    }
    if (eId2 === undefined) {
      eId2 = this.eventId();
    }
    var realDeltaX = this.character(eId1)._realX - this.character(eId2)._realX;
    var realDeltaY = this.character(eId1)._realY - this.character(eId2)._realY;
    return Math.sqrt(Math.pow(realDeltaX, 2) + Math.pow(realDeltaY, 2));
  };

  //=============================================================================
  // 自動振り向き用の関数
  //=============================================================================

  // プレイヤーから引数距離以内のイベントリスト
  Game_Map.prototype.autoLockEnemiesInDistance = function (distance) {
    return this.events().filter(
      function (event) {
        var subj = $gamePlayer;
        var deltaX = event._realX - subj._realX;
        var deltaY = event._realY - subj._realY;
        var delta = Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
        return delta <= distance
          && event.event().meta.ABSenemy > 0
          //&& event.event().meta.ABSbreakable === true
          //&& !event.event().meta.ABSweed
          //&& event.ABSdefeated === false
          //&& event.ABSinvincible === false
          && $gameSelfSwitches.value([$gameMap._mapId, event._eventId, "B"]) == false
      }
    );
  };

  // プレイヤーから引数距離以内のイベントIDリスト
  Game_Map.prototype.autoLockEnemyIdInDistance = function (distance) {
    var events = this.autoLockEnemiesInDistance(distance);
    if (events.length <= 0) return 0;
    var deltaList = events.map(
      function (event) {
        var subj = $gamePlayer;
        var deltaX = event._realX - subj._realX;
        var deltaY = event._realY - subj._realY;
        var delta = Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
        return delta;
      }
    );
    var elmNum = deltaList.indexOf(Math.min.apply(null, deltaList));
    var eventId = events[elmNum].eventId();
    console.log(eventId);
    return eventId;
  };

  // プレイヤーから引数距離以内のイベントID
  // 存在しない場合は 0 を返す
  /*
  Game_Map.prototype.autoLockEnemyIdInDistance = function (distance) {
    var eventIds = this.autoLockEnemyIdsInDistance(distance);
    var eventId = eventIds.length > 0 ? eventIds[0] : 0;
    return eventId;
  };
  */

  //=============================================================================
  // 接触判定用の関数
  //=============================================================================

  var _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);
    //$gameMap.touchEnemy(1.1);
  };

  Game_Map.prototype.touchEnemy = function (dist) {
    var collideEnemy = $gameMap.ABSenemyIdInDistance(dist);
    if (collideEnemy > 0) {
      var attribute = $gameVariables._data[attributeVarId];
      var sufferDamage = Game_Interpreter.prototype.arpgSufferDamegeValue(collideEnemy);
      $gameVariables._data[sufferDamageVarId] = sufferDamage;
      $gameSwitches.setValue(sufferDamageSwiId, true);
    }
  };

  // プレイヤーから引数距離以内のイベントリスト
  Game_Map.prototype.enemiesInDistance = function (distance, indiv) {
    return this.events().filter(
      function (event) {
        var subj = indiv === undefined ? $gamePlayer : $gameMap.event(indiv);
        var deltaX = event._realX - subj._realX;
        var deltaY = event._realY - subj._realY;
        var delta = Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
        return delta <= distance
          && event.event().meta.ABSenemy > 0
          && !event.event().meta.ABSoneShot
          && event.ABSignoreTouchEnemy === false
          && event.ABSdefeated === false
      }
    );
  };

  // プレイヤーから引数距離以内のイベントIDリスト
  Game_Map.prototype.ABSenemyIdsInDistance = function (distance, indiv) {
    var events = this.enemiesInDistance(distance, indiv);
    var eventIds = events.map(
      function (event) {
        return event.eventId();
      }
    );
    return eventIds;
  };

  // プレイヤーから引数距離以内のイベントID
  // 存在しない場合は 0 を返す
  Game_Map.prototype.ABSenemyIdInDistance = function (distance, indiv) {
    var eventIds = this.ABSenemyIdsInDistance(distance, indiv);
    var eventId = eventIds.length > 0 ? eventIds[0] : 0;
    return eventId;
  };

  //=============================================================================
  // 攻撃距離測定関数を定義 Supported by サンシロ
  //=============================================================================

  // プレイヤーから引数距離以内のイベントリスト
  Game_Map.prototype.eventsInDistance = function (width, height, offsetX, offsetY, indiv) {
    return this.events().filter(
      function (event) {
        if (indiv === -1) {
          var originX = $gamePlayer._realX + offsetX;
          var originY = $gamePlayer._realY + offsetY;
        } else {
          var originX = $gameMap.event(indiv)._realX + offsetX;
          var originY = $gameMap.event(indiv)._realY + offsetY;
        }
        var hitX = 0;
        var hitY = 0;
        if (originX - width / 2 <= event._realX && event._realX <= originX + width / 2) {
          hitX = 1;
        }
        if (originY - height / 2 <= event._realY && event._realY <= originY + height / 2) {
          hitY = 1;
        }
        return ((hitX + hitY === 2
            && event.event().meta.ABSenemy > 0
            && event.ABSinvincible === false
            && event.ABSdefeated === false)
            || (hitX + hitY === 2 && event.event().meta.ABSweed))
        //&& Math.sqrt(Math.pow(($gamePlayer.prJumpHeight - event.prJumpHeight),2)) < 4
      }
    );
  };

  // プレイヤーから引数距離以内のイベントIDリスト
  Game_Map.prototype.eventIdsInDistance = function (width, height, offsetX, offsetY, indiv) {
    var events = this.eventsInDistance(width, height, offsetX, offsetY, indiv);
    var eventIds = events.map(
      function (event) {
        return event.eventId();
      }
    );
    return eventIds;
  };

  // プレイヤーから引数距離以内のイベントID
  // 存在しない場合は 0 を返す
  Game_Map.prototype.eventIdInDistance = function (distance) {
    var eventIds = this.eventIdsInDistance(distance * 2, distance * 2, 0, 0, -1);
    var eventId = eventIds.length > 0 ? eventIds[0] : 0;
    return eventId;
  };

  // プレイヤーから引数距離以内のすり抜けなしイベントリスト
  Game_Map.prototype.eventsInDistanceNt = function (distance) {
    var events = this.eventsInDistance(distance);
    events = events.filter(
      function (event) {
        return !event.isThrough();
      }
    );
    return events;
  };

  // プレイヤーから引数距離以内のすり抜けなしイベントIDリスト
  Game_Map.prototype.eventIdsInDistanceNt = function (distance) {
    var events = this.eventsInDistanceNt(distance);
    var eventIds = events.map(
      function (event) {
        return event.eventId();
      }
    );
    return eventIds;
  };

  // プレイヤーから引数距離以内のすり抜けなしイベントID
  // 存在しない場合は 0 を返す
  Game_Map.prototype.eventIdInDistanceNt = function (distance) {
    var eventIds = this.eventIdsInDistanceNt(distance);
    var eventId = eventIds.length > 0 ? eventIds[0] : 0;
    return eventId;
  };



})();
