/*:
* @plugindesc システムボイス制御
* @target MZ
*
*
*
*
*
*/

(function () {

    // システムボイス
    AudioManager.playSystemVoice = function (type) {
        let speecher = $gameVariables.value(181);
        if (speecher == 0) return;
        let cv = {};
        let prefix;
        let suffixArr = [];
        let suffix;
        if (speecher == 7) speecher = Math.floor(Math.random() * 6 + 1);
        switch (speecher) {
            case 1: prefix = 'bell'; suffixArr = ['_system_01b', '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
            case 2: prefix = 'repp'; suffixArr = ['_system_01b', '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
            case 3: prefix = 'cher'; suffixArr = ['_system_01',  '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
            case 4: prefix = 'suii'; suffixArr = ['_system_01',  '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
            case 5: prefix = 'chuu'; suffixArr = ['_system_01',  '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
            case 6: prefix = 'arta'; suffixArr = ['_system_01',  '_system_02', '_system_03', '_system_04', '_system_05', '_system_06', '_system_07']; break;
        }
        switch (type) {
            case 'title': suffix = suffixArr[0]; break;
            case 'save': suffix = suffixArr[1]; break;
            case 'saving': suffix = suffixArr[2]; break;
            case 'load': suffix = suffixArr[3]; break;
            case 'loading': suffix = suffixArr[4]; break;
            case 'config': suffix = suffixArr[5]; break;
            case 'volume': suffix = suffixArr[6]; break;
        }
        let femaleVoice = true;
        let maleVoice = true;
        cv.name = String(prefix + suffix);
        cv.volume = femaleVoice == true ? 90 : 0;
        cv.pitch = 100;
        cv.pan = 0;
        if ($gameTemp.isPlaytest()) console.log('cv param:'+cv.name);
        //if (speecher == 7 && (type != 'title' || type != 'volume')) return;
        AudioManager.playCv(cv);
    };

    let _Scene_Title_playTitleMusic = Scene_Title.prototype.playTitleMusic;
    Scene_Title.prototype.playTitleMusic = function () {
        _Scene_Title_playTitleMusic.call(this);
        AudioManager.playSystemVoice('title');
    };

    let _Scene_Options_create = Scene_Options.prototype.create;
    Scene_Options.prototype.create = function () {
        _Scene_Options_create.call(this);
        AudioManager.playSystemVoice('config');
    };

    let _Scene_Save_mode = Scene_Save.prototype.mode;
    Scene_Save.prototype.mode = function () {
        AudioManager.playSystemVoice('save');
        return _Scene_Save_mode.call(this);
    };

    let _Scene_Save_onSaveSuccess = Scene_Save.prototype.onSaveSuccess;
    Scene_Save.prototype.onSaveSuccess = function () {
        _Scene_Save_onSaveSuccess.call(this);
        AudioManager.playSystemVoice('saving');
    };

    let _Scene_Load_mode = Scene_Load.prototype.mode;
    Scene_Load.prototype.mode = function () {
        AudioManager.playSystemVoice('load');
        return _Scene_Load_mode.call(this);
    };

    let _Scene_Load_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
    Scene_Load.prototype.onLoadSuccess = function () {
        _Scene_Load_onLoadSuccess.call(this);
        AudioManager.playSystemVoice('loading');
    };

    /*
    let _Window_Options_changeValue = Window_Options.prototype.changeValue;
    Window_Options.prototype.changeValue = function(symbol, value) {
        const lastValue = this.getConfigValue(symbol);
        if (lastValue !== value) {
            this.setConfigValue(symbol, value);
            this.redrawItem(this.findSymbol(symbol));
            this.playCursorSound();
            console.log(symbol);
            AudioManager.stopCv();
            if (symbol == 'cvVolume') AudioManager.playSystemVoice('volume');
        }
    };
    */

})();

