/*:
 * @plugindesc コンフィグ画面の表示項目行数とウィンドウのy座標を変更するプラグイン
 * @target MZ
 * @help このプラグインは、コンフィグ画面の表示項目行数とウィンドウのy座標を変更します。
 *
 * @param visibleRows
 * @text 表示行数
 * @type number
 * @min 1
 * @desc コンフィグ画面で表示する項目の行数を設定します。
 * @default 10
 *
 * @param windowY
 * @text ウィンドウY座標
 * @type number
 * @min 0
 * @desc コンフィグ画面ウィンドウのY座標を設定します。
 * @default 0
 */

(() => {
    const parameters = PluginManager.parameters('PRTN_CustomConfigRows');
    const visibleRows = Number(parameters['visibleRows'] || 10);
    const windowY = Number(parameters['windowY'] || 0);

    const _Scene_Options_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
    Scene_Options.prototype.createOptionsWindow = function() {
        const rect = this.optionsWindowRect();
        rect.y = windowY; // ウィンドウのY座標を設定
        this._optionsWindow = new Window_Options(rect);
        this._optionsWindow.setHandler("cancel", this.popScene.bind(this));
        this.addWindow(this._optionsWindow);
    };

    const _Window_Options_initialize = Window_Options.prototype.initialize;
    Window_Options.prototype.initialize = function(rect) {
        rect.height = this.fittingHeight(visibleRows+2);
        _Window_Options_initialize.call(this, rect);
    };
})();
