/*:
* @plugindesc 画面の描画を指定フレームレートに制限する
* @author Perutan
*
* @param 変数ID
* @desc 指定フレームレートを格納する変数ID
* @type variable
* @default 0
*
* @param スイッチID
* @desc 機能オンオフを制御するスイッチID
* @type switch
* @default 0
*
*
*
*
*/

let PRTN_DrawControl_frame = 0;
let PRTN_SuppressionCounter = 0;

(function () {
  

    //=============================================================================
    // プラグインパラメータの取得
    //=============================================================================
  
    var pluginName = 'PRTN_DrawControl_3';
    var parameters = PluginManager.parameters('PRTN_DrawControl_3');
    var PDCframeRateVarId = Number(parameters['変数ID']);
    var PDCavailableSwiId = Number(parameters['スイッチID']);

  
  
    //=============================================================================
    // プラグインコマンド
    //=============================================================================
  
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
    
    }
  
    //=============================================================================
    // 実行用の関数
    //=============================================================================
  
    SceneManager.PDC_DefineRate = function() {
        if (!$gameSwitches) {
            return 60;
        }
        var rate = 60;
        if ($gameSwitches.value(PDCavailableSwiId) === true) {
            /*
            if ($gameVariables != null) {
                rate = $gameVariables.value(PDCframeRateVarId) || 60;
                //console.log(PDCframeRateVarId);
                if (rate > 30 && rate !== 60) {
                    rate = 60;
                }
            }    
            */
            rate = 30; 
        } else {
            rate = 60; 
        }
        return rate;
    };

    SceneManager.PDC_checkFpsRate = function(rate) {

        if (!$gameSwitches) {
            return true;
        }

        if (this.meetFPSCondition() === false) {
            PRTN_SuppressionCounter = 30;
        } else {
            PRTN_SuppressionCounter -= 1;
            if (PRTN_SuppressionCounter < 0) PRTN_SuppressionCounter = 0;
        }

        //console.log("counter:"+PRTN_SuppressionCounter);

        if ($gameSwitches.value(PDCavailableSwiId)) {
            return PRTN_DrawControl_frame % (60/rate) == 0;
        } else {
            return PRTN_SuppressionCounter % 2 == 0;
        }
    };

    //-----------------------------------------------------------
    // rpg_manager

    SceneManager._smoothDeltaTime = 1;
    SceneManager._elapsedTime = 0;
    SceneManager._mzDeltaTime = 0;
    SceneManager._lastTime = 0;

    SceneManager.update = function(deltaTime) {
        try {
            this.tickStart();
            this._mzDeltaTime = (deltaTime - this._lastTime) * PIXI.settings.TARGET_FPMS;
            this._lastTime = deltaTime;
            //const n = this.determineRepeatNumber(this._smoothDeltaTime);
            //for (let i = 0; i < n; i++) {
                this.updateManagers();
                this.updateMain();
                this.tickEnd();        
            //}
        } catch (e) {
            this.catchException(e);
        }
    };

    SceneManager.determineRepeatNumber = function(deltaTime) {
        // [Note] We consider environments where the refresh rate is higher than
        //   60Hz, but ignore sudden irregular deltaTime.
        this._smoothDeltaTime *= 0.8;
        this._smoothDeltaTime += Math.min(deltaTime, 2) * 0.2;
        if (this._smoothDeltaTime >= 0.9) {
            this._elapsedTime = 0;
            //return Math.round(this._smoothDeltaTime);
            return 1;   // 低スペックPCでループ回数を増やすと、FPSが一層悪化するため、更新回数を1に留めた方が良いかもしれない。
        } else {
            this._elapsedTime += deltaTime;
            if (this._elapsedTime >= 1) {
                this._elapsedTime -= 1;
                return 1;
            }
            return 0;
        }
    };

    /*
    SceneManager.updateMain = function() {
        this.updateInputData();
        this.changeScene();
        this.updateScene();
        this.renderScene();
        this.requestUpdate();
    };
    */

    const _margin = 0.0;
    const _SceneManager_updateMain = SceneManager.updateMain;
    SceneManager.updateMain = function() {
        PRTN_DrawControl_frame++;

        /*
        if (Utils.isMobileSafari()) {
            this.changeScene();
            this.updateScene();
        } else {
            var newTime = this._getTimeInMsWithoutMobileSafari();
            var fTime = (newTime - this._currentTime) / 1000;
            if (fTime > 0.25) fTime = 0.25;
            this._currentTime = newTime;
            this._accumulator += fTime;
            while (this._accumulator >= this._deltaTime) {
                this.updateInputData();
                this.changeScene();
                this.updateScene();
                this._accumulator -= this._deltaTime;
            }
        }
        */

       var newTime = this._getTimeInMsWithoutMobileSafari();
       var fTime = (newTime - this._currentTime) / 1000;
       if (fTime > 0.25) fTime = 0.25;
       this._momentFPS = 1/fTime;
       this._meanFPSArr.push(this._momentFPS);
       if (this._meanFPSArr.length > meanFPSFrames) this._meanFPSArr.shift();    
       this._currentTime = newTime;
       this._accumulator += fTime;
        const n = this.determineRepeatNumber(this._mzDeltaTime);
        //console.log('n: ' + n + ', deltaTime: ' + this._mzDeltaTime);
        for (let i = 0; i < n; i++) {
        //while (this._accumulator >= this._deltaTime + _margin) {
            this.updateInputData();
            this.changeScene();
            this.updateScene();
            //this._accumulator = 0;
        //}
        }



        var rate = this.PDC_DefineRate();
        //console.log(this.PDC_checkFpsRate(rate));
        if (this.PDC_checkFpsRate(rate) === true) {
            this.renderScene();
        }
        this.requestUpdate();
    };

    
    //-----------------------------------------------------------
    // rpg_manager (ツキミ様作「WaitFps.js」より引用の上機能をマージ)

    var momentFPSThreshold = 30;
    var meanFPSThreshold = 50;
    var meanFPSFrames = 5;

    SceneManager._momentFPS = 0;
    SceneManager._meanFPSArr = [];
    
    SceneManager.meetFPSCondition = function() {
        var meanFPS = 0;
        for(var i = 0; i < this._meanFPSArr.length; i++) {
            meanFPS += this._meanFPSArr[i];
        }
        meanFPS /= this._meanFPSArr.length;
        return (this._momentFPS > momentFPSThreshold && meanFPS > meanFPSThreshold);
    };

    //-----------------------------------------------------------
    // YEP_FpsSynchOption
    
    /*
    SceneManager.updateMainNoFpsSynch = function() {
        PRTN_DrawControl_frame++;

        this.updateInputData();
        this.changeScene();
        this.updateScene();
        //var rate = this.PDC_DefineRate();
        if (this.PDC_checkFpsRate() === true) {
            this.renderScene();
        }
        this.requestUpdate();
    };
    */
  
  })();
  
