/*:
 * @plugindesc 指定したイベントに紐付けられたエネミーの各種パラーメータを取得する
 *
 * @method eventAtk
 * @syntax eventAtk(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} atk
 *
 * @method eventSpd
 * @syntax eventSpd(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} spd
 *
 * @method eventHp
 * @syntax eventHp(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} MaxHP
 *
 * @method eventExp
 * @syntax eventExp(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} exp

 * @method eventGold
 * @syntax eventGold(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} gold
 *
 * @method eventWeak
 * @syntax eventWeak(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} attributeWeak
 *
 * @method eventResist
 * @syntax eventResist(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} attributeResist
 *
 * @method eventName
 * @syntax eventName(eventId)
 * @parameters {Number, undefined} eventId (省略時は　this.eventId() )
 * @return {Number} Name
 */


(function() {
  'use strict'

  //------------------------------------------------------------------------------
  // 攻撃力
  Game_Interpreter.prototype.eventAtk = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].params[2];
  };

  //------------------------------------------------------------------------------
  // 敏捷性
  Game_Interpreter.prototype.eventSpd = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].params[6];
  };

  //------------------------------------------------------------------------------
  // 最大HP
  Game_Interpreter.prototype.eventHp = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].params[0];
  };

  //------------------------------------------------------------------------------
  // 所持金
  Game_Interpreter.prototype.eventGold = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].gold;
  };

  //------------------------------------------------------------------------------
  // 経験値
  Game_Interpreter.prototype.eventExp = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].exp;
  };

  //------------------------------------------------------------------------------
  // 弱点属性（メモ欄）
  Game_Interpreter.prototype.eventWeak = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].meta["weak"] || 0;
  };

  //------------------------------------------------------------------------------
  // 耐性（メモ欄）
  Game_Interpreter.prototype.eventResist = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].meta["resist"] || 0;
  };

  //------------------------------------------------------------------------------
  // 追加耐性（メモ欄）
  Game_Interpreter.prototype.eventAddResist = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].meta["addResist"] || 0;
  };


  //------------------------------------------------------------------------------
  // ドロップ抽選の分母（敵の運から取得）
  Game_Interpreter.prototype.eventDropDenom = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].params[7] || 0;
  };

  //------------------------------------------------------------------------------
  // 名前
  Game_Interpreter.prototype.eventName = function (eId) {
    if (eId === undefined) {
      eId = this.eventId();
    }
    return $dataEnemies[Number($gameMap.event(eId).event().meta.enm)].name || 0;
  };


})();
