/*:
* @plugindesc オリジナルのジャンプ機能を追加する
* @author Perutan
*
*
*
* @help
* 
*
*/

(function () {
  'use strict'

  //=============================================================================
  // プラグインパラメータの取得
  //=============================================================================
  var pluginName = 'PRTN_JumpControl';
  var parameters = PluginManager.parameters('PRTN_JumpControl');

  //=============================================================================
  // 変数およびスイッチID代入
  //=============================================================================

  //スイッチ
  var prJumpInAirSwiId = 44;  //空中にいる
  var prJumpLandingSwiId = 57;   //ジャンプ着地


  //=============================================================================
  // 追加する関数
  //=============================================================================

  //=============================================================================
  // Game_CharacterBase
  //   メンバ・プロパティを追加
  //=============================================================================

  var _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
  Game_CharacterBase.prototype.initMembers = function () {
    _Game_CharacterBase_initMembers.apply(this, arguments);
    this.prJump = false;
    this.prJumpPower = 0;
    this.prJumpHeight = 0;
    this.prJumpOffset = 0;
  };

  var _Game_CharacterBase_update = Game_CharacterBase.prototype.update;
  Game_CharacterBase.prototype.update = function () {
    if (this.prJump) this.updatePrJump();
    _Game_CharacterBase_update.apply(this);
  };

  //=============================================================================
  // ジャンプ用の関数
  //=============================================================================

  Game_CharacterBase.prototype.startPrJump = function (power, offset) {
    this.prJump = true;
    this.prJumpPower = power;
    this.prJumpHeight = 0;
    this.prJumpOffset = offset-6;
    /*
    if (this._eventId > 0) {
    } else {
      var ersX = this._realX;
      var ersY = this._realY;
      var args = new Array('ジャンプ影', String(ersX), String(ersY));
      Game_Interpreter.prototype.pluginCommand("ERS_MAKE_TEMPLATE", args);
      $gameSwitches.setValue(prJumpInAirSwiId, true);
    }
    */
  };

  Game_CharacterBase.prototype.updatePrJump = function () {
    this.prJumpHeight += this.prJumpPower; //ジャンプ高度・ジャンプ力
    var jy = this.prJumpHeight * -1;
    //this.shiftPosition(0, (jy*0.75 + this.prJumpOffset));
    this.prJumpPower -= 0.5;
    if (this.prJumpHeight > 48) {
      this.setPriorityType(1.1);
    } else {
      this.setPriorityType(1);
    }
    if (this.prJumpHeight < 0) {
      this.prJumpHeight = 0;
      //this.shiftPosition(0, this.prJumpOffset);
      if (!this._eventId > 0) {
        this.setPriorityType(1);
        $gameSwitches.setValue(prJumpLandingSwiId, true);
      }
      this.prJump = false;
    }
  };

  var _Game_CharacterBase_screenY = Game_CharacterBase.prototype.screenY;
  Game_CharacterBase.prototype.screenY = function () {
    var th = $gameMap.tileHeight();
    return Math.round(this.scrolledY() * th + th -
      this.shiftY() - this.jumpHeight() - this.prJumpHeight);
  };

  /*
  Sprite_BasicShadow.prototype.update = function () {
    this.x = this._character.screenX();
    this.y = this._character.screenY() + this._character.jumpHeight() + Galv.BES.os;
    this.z = this._character.screenZ() - 1;
    if (this._character._characterName == "" || this._character._transparent) {
      this.opacity = 0;
    } else {
      this.opacity = this._character._opacity
    };
  };
  */

  // SAN_AnalogMove 衝突キャラクター　：ジャンプで草と敵を飛び越える
  CharacterMover.prototype.collidingCharacters = function () {
    var characters = [];
    if (!this.isThrough()) {
      characters = $gameMap.allCharacters().filter(
        function (character) {
          return this.isCollidingCharacter(character) &&
            ($gamePlayer.prJump === false || ($gamePlayer.prJump === true && (!character.event().meta.jumpable)))
        }, this
      );
    }
    return characters;
  };

})();
