/*:
* @plugindesc 指定操作に割り当てられたキーの名前を返す
* @author Perutan
*
*
*
*/

(function () {
    'use strict'

    //=============================================================================
    // プラグインパラメータの取得
    //=============================================================================

    var pluginName = 'PRTN_KeyToChar';
    var parameters = PluginManager.parameters('PRTN_KeyToChar');

    //=============================================================================
    // 処理内容
    //=============================================================================

    // 指定キーをキーネームに変換

    Game_Interpreter.prototype.keyToChar = function (pressedKey,iconSize) {
        if ($gameVariables.value(133) > 0) {
            return this.buttonToChar(pressedKey,iconSize);
        } else {
            return this.keyboardToChar(pressedKey).toUpperCase();
        }
            return this.keyboardToChar(pressedKey).toUpperCase();
    };

    Game_Interpreter.prototype.buttonToChar = function (pressedKey,iconSize) {
        var i = Input.getGamepadButton(pressedKey);
        let iconId;
        let str;
        if ($gameVariables.value(133) == 1) {
            switch (i) {
                case 0: iconId = 1169; break;
                case 1: iconId = 1170; break;
                case 2: iconId = 1171; break;
                case 3: iconId = 1172; break;
                case 4: iconId = 1173; break;
                case 5: iconId = 1174; break;
                case 6: iconId = 1175; break;
                case 7: iconId = 1176; break;
                default: return this.keyboardToChar(pressedKey).toUpperCase();
            }    
        } else {
            switch (i) {
                case 0: iconId = 1177; break;
                case 1: iconId = 1178; break;
                case 2: iconId = 1179; break;
                case 3: iconId = 1180; break;
                case 4: iconId = 1181; break;
                case 5: iconId = 1182; break;
                case 6: iconId = 1183; break;
                case 7: iconId = 1184; break;
                default: return this.keyboardToChar(pressedKey).toUpperCase();
            }    
        }
        if (iconSize) {
            str = String("\\I["+iconId+", "+Number(iconSize)+"]");
        } else {
            str = String("\\I["+iconId+"]");
        }
        return str;
    };

    Input.getGamepadButton = function(type) {
        for (var i = 0; i < 12; ++i) {
            if (Input.gamepadMapper[i] === type) return i;
        }
        return null;
    };
    Game_Interpreter.prototype.keyboardToChar = function (pressedKey) {
        var b = Object.keys(Input.keyMapper).filter(
            function (value) {
                return Input.keyMapper[value] == pressedKey && 48 <= value && value <= 90;
            }
        );
        if (b.length == 0) {
            var b = Object.keys(Input.keyMapper).filter(
                function (value) {
                    return Input.keyMapper[value] == pressedKey;
                }
            );
        }
        //console.log(b);

        var c = 0;
        var i = 0;

        var c = Number(b[i]);
        //console.log(c);
        for (var i = 0; i < 9; i++) {
            var d = this.modifierKeyName(b[i]);
            if (d != undefined) break;
        }
        //console.log(d);

        if (d == undefined) var d = 'none';

        return d;
    };

    Game_Interpreter.prototype.modifierKeyName = function (kCode) {
        //console.log('Hi ' + kCode);
        var kName = Object.keys(Input.keyCodeReverseMapper).filter(function (value) {
            return Input.keyCodeReverseMapper[String(value)] == kCode;
        });
        //console.log('Go ' + kName);
        var kn = kName[0];
        for (var i = 0; i < kName.length; i++) {
            if (kName[i] !== undefined) kn = kName[i];
        }
        return kn;
        /*
        if (48 <= kCode && kCode <= 90) {
          var kName = String.fromCharCode(kCode);
          console.log(kName);
        } else {
          switch (kCode) {
            case 16: var kName = 'Shift'; break;
            default: var kName = '';
          }  
        }
        return kName;
        */

    };
})();
