/*:
* @plugindesc コアスクリプトの記述を書き換える
* @target MZ
*
*
*
*
*
*/

(function () {
    // メッセージのマージン量
    Window_Message.prototype.newLineX = function (textState) {
        const faceExists = $gameMessage.faceName() !== "";
        const faceWidth = ImageManager.faceWidth;
        const spacing = 20;
        const margin = faceExists ? faceWidth + spacing : 4;
        return textState.rtl ? this.innerWidth - margin + 120 : margin + 120;
    };

    //メッセージウィンドウの行数を変更
    Scene_Message.prototype.messageWindowRect = function () {
        return new Rectangle(0, 0, Graphics.boxWidth, this.calcWindowHeight(3.5, false));
    };

    //updateAnywhere
    var _Game_Event_initialize = Game_Event.prototype.initialize;
    Game_Event.prototype.initialize = function (mapId, eventId) {
        _Game_Event_initialize.call(this, mapId, eventId);

        var data = this.event();
        this._updateAnywhere = data && (data.meta.updateAnywhere || data.meta.lift);
    };

    Game_Event.prototype.isNearTheScreen = function () {
        if (this._updateAnywhere) return true;
        return Game_Character.prototype.isNearTheScreen.call(this);
    };

    // NameBoxの位置変更
    Window_NameBox.prototype.updatePlacement = function () {
        this.width = this.windowWidth();
        this.height = this.windowHeight();
        const messageWindow = this._messageWindow;
        if ($gameMessage.isRTL()) {
            this.x = messageWindow.x + messageWindow.width - this.width - 60;
        } else {
            this.x = messageWindow.x + 60;
        }
        if (messageWindow.y > 0) {
            this.y = messageWindow.y - this.height;
        } else {
            this.y = messageWindow.y + messageWindow.height;
        }
    };

    // 敵キャラの表示Z座標を通常と同じにする
    const _Game_CharacterBase_screenZ = Game_CharacterBase.prototype.screenZ;
    Game_CharacterBase.prototype.screenZ = function () {
        if (this._eventId > 0) {
            if (this.event().meta.ABSenemy > 0) {
                return 2 + _Game_CharacterBase_screenZ.apply(this);
            } else {
                return _Game_CharacterBase_screenZ.apply(this);
            }
        } else {
            return _Game_CharacterBase_screenZ.apply(this);
        }
    }

    // 大きい敵キャラに裏周りした場合の処理
    const _Game_Event_update = Game_Event.prototype.update;
    Game_Event.prototype.update = function() {
        _Game_Event_update.call(this);
        if (Math.abs(this._x - $gamePlayer._x) < 3 && 0 < this._y - $gamePlayer._y && this._y - $gamePlayer._y < 3 && this._scaleY > 130) {
            this._extraOpacity = -80;
            this.setOpacity(this._opacity);
        } else {
            this._extraOpacity = 0;
            this.setOpacity(this._opacity);
        }
    };

    const _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBase_initMembers.call(this);
        this._extraOpacity = 0;
    };

    const _Game_CharacterBase_opacity = Game_CharacterBase.prototype.opacity;
    Game_CharacterBase.prototype.opacity = function() {
        return this._opacity + this._extraOpacity;
    };

    //ウィンドウの開閉を早くする
    Window_Base.prototype.updateOpen = function () {
        if (this._opening) {
            this.openness += 64;
            if (this.isOpen()) {
                this._opening = false;
            }
        }
    };

    Window_Base.prototype.updateClose = function () {
        if (this._closing) {
            this.openness -= 64;
            if (this.isClosed()) {
                this._closing = false;
            }
        }
    };

    // FastForwardにスキップボタンを追加
    Scene_Map.prototype.isFastForward = function () {
        return (
            $gameMap.isEventRunning() &&
            !SceneManager.isSceneChanging() &&
            (Input.isLongPressed("ok") || TouchInput.isLongPressed() || $gameMessage.skipFlg()) // modified
        );
    };

    //ダッシュ禁止
    Game_Player.prototype.isDashButtonPressed = function() {
        return false;
        const shift = Input.isPressed("shift");
        if (ConfigManager.alwaysDash) {
            return !shift;
        } else {
            return shift;
        }
    };
    
    //エラー対応
    SceneManager.onError = function (event) {
        console.error(event.message);
        console.error(event.filename, event.lineno);
        try {
            /*
            this.stop();
            Graphics.printError("Error", event.message, event);
            AudioManager.stopAll();
            */
        } catch (e) {
            //
        }
    };

    // スクリプトコマンドのエラー落ち回避
    Game_Interpreter.prototype.command355 = function () {
        let script = this.currentCommand().parameters[0] + "\n";
        while (this.nextEventCode() === 655) {
            this._index++;
            script += this.currentCommand().parameters[0] + "\n";
        }
        try {
            eval(script);
        } catch (e) {
            console.error(e);
            let eid = this._eventId;
            let nam = $gameMap.event(eid) ? $gameMap.event(eid).event().name : 'undefined';
            let idx = this._index;
            console.error("at Script Call (command) > eventId : " + eid + " (" + nam + ") " + " index : " + idx);
            if ($gameTemp.isPlaytest()) $gameSwitches.setValue(32, true);
        }
        return true;
    };

    /*
    const _Game_Interpreter_command355 = Game_Interpreter.prototype.command355;
    Game_Interpreter.prototype.command355 = function (params) {
        try {
            _Game_Interpreter_command355.call(this, params);
        } catch (e) {
            console.error(e);
            let eid = this._eventId;
            let nam = $gameMap.event(eid) ? $gameMap.event(eid).event().name : 'undefined';
            let idx = this._index;
            console.error("at Script Call (command)> eventId : " + eid + " (" + nam + ") " + " index : " + idx);
            if ($gameTemp.isPlaytest()) $gameSwitches.setValue(32, true);        
        }
    };
    */

    // Control Variables
    Game_Interpreter.prototype.command122 = function (params) {
        const startId = params[0];
        const endId = params[1];
        const operationType = params[2];
        const operand = params[3];
        let value = 0;
        let randomMax = 1;
        switch (operand) {
            case 0: // Constant
                value = params[4];
                break;
            case 1: // Variable
                value = $gameVariables.value(params[4]);
                break;
            case 2: // Random
                value = params[4];
                randomMax = params[5] - params[4] + 1;
                randomMax = Math.max(randomMax, 1);
                break;
            case 3: // Game Data
                value = this.gameDataOperand(params[4], params[5], params[6]);
                break;
            case 4: // Script
                try {
                    value = eval(params[4]);
                } catch (e) {
                    console.error(e);
                    let eid = this._eventId;
                    let nam = $gameMap.event(eid) ? $gameMap.event(eid).event().name : 'undefined';
                    let idx = this._index;
                    console.error("at Script Call (variables) > eventId : " + eid + " (" + nam + ") " + " index : " + idx);
                    if ($gameTemp.isPlaytest()) $gameSwitches.setValue(32, true);        
                }
                break;
        }
        for (let i = startId; i <= endId; i++) {
            if (typeof value === "number") {
                const realValue = value + Math.randomInt(randomMax);
                this.operateVariable(i, operationType, realValue);
            } else {
                this.operateVariable(i, operationType, value);
            }
        }
        return true;
    };

    /*
    const _Game_Interpreter_command122 = Game_Interpreter.prototype.command122;
    Game_Interpreter.prototype.command122 = function (params) {
        try {
            _Game_Interpreter_command122.call(this, params);
        } catch (e) {
            console.error(e);
            let eid = this._eventId;
            let nam = $gameMap.event(eid) ? $gameMap.event(eid).event().name : 'undefined';
            let idx = this._index;
            console.error("at Script Call (variable)> eventId : " + eid + " (" + nam + ") " + " index : " + idx);
            if ($gameTemp.isPlaytest()) $gameSwitches.setValue(32, true);        
        }
    };
    */
    
    // Conditional Branch
    Game_Interpreter.prototype.command111 = function (params) {
        let result = false;
        let value1, value2;
        let actor, enemy, character;
        switch (params[0]) {
            case 0: // Switch
                result = $gameSwitches.value(params[1]) === (params[2] === 0);
                break;
            case 1: // Variable
                value1 = $gameVariables.value(params[1]);
                if (params[2] === 0) {
                    value2 = params[3];
                } else {
                    value2 = $gameVariables.value(params[3]);
                }
                switch (params[4]) {
                    case 0: // Equal to
                        result = value1 === value2;
                        break;
                    case 1: // Greater than or Equal to
                        result = value1 >= value2;
                        break;
                    case 2: // Less than or Equal to
                        result = value1 <= value2;
                        break;
                    case 3: // Greater than
                        result = value1 > value2;
                        break;
                    case 4: // Less than
                        result = value1 < value2;
                        break;
                    case 5: // Not Equal to
                        result = value1 !== value2;
                        break;
                }
                break;
            case 2: // Self Switch
                if (this._eventId > 0) {
                    const key = [this._mapId, this._eventId, params[1]];
                    result = $gameSelfSwitches.value(key) === (params[2] === 0);
                }
                break;
            case 3: // Timer
                if ($gameTimer.isWorking()) {
                    const sec = $gameTimer.frames() / 60;
                    if (params[2] === 0) {
                        result = sec >= params[1];
                    } else {
                        result = sec <= params[1];
                    }
                }
                break;
            case 4: // Actor
                actor = $gameActors.actor(params[1]);
                if (actor) {
                    const n = params[3];
                    switch (params[2]) {
                        case 0: // In the Party
                            result = $gameParty.members().includes(actor);
                            break;
                        case 1: // Name
                            result = actor.name() === n;
                            break;
                        case 2: // Class
                            result = actor.isClass($dataClasses[n]);
                            break;
                        case 3: // Skill
                            result = actor.hasSkill(n);
                            break;
                        case 4: // Weapon
                            result = actor.hasWeapon($dataWeapons[n]);
                            break;
                        case 5: // Armor
                            result = actor.hasArmor($dataArmors[n]);
                            break;
                        case 6: // State
                            result = actor.isStateAffected(n);
                            break;
                    }
                }
                break;
            case 5: // Enemy
                enemy = $gameTroop.members()[params[1]];
                if (enemy) {
                    switch (params[2]) {
                        case 0: // Appeared
                            result = enemy.isAlive();
                            break;
                        case 1: // State
                            result = enemy.isStateAffected(params[3]);
                            break;
                    }
                }
                break;
            case 6: // Character
                character = this.character(params[1]);
                if (character) {
                    result = character.direction() === params[2];
                }
                break;
            case 7: // Gold
                switch (params[2]) {
                    case 0: // Greater than or equal to
                        result = $gameParty.gold() >= params[1];
                        break;
                    case 1: // Less than or equal to
                        result = $gameParty.gold() <= params[1];
                        break;
                    case 2: // Less than
                        result = $gameParty.gold() < params[1];
                        break;
                }
                break;
            case 8: // Item
                result = $gameParty.hasItem($dataItems[params[1]]);
                break;
            case 9: // Weapon
                result = $gameParty.hasItem($dataWeapons[params[1]], params[2]);
                break;
            case 10: // Armor
                result = $gameParty.hasItem($dataArmors[params[1]], params[2]);
                break;
            case 11: // Button
                switch (params[2] || 0) {
                    case 0:
                        result = Input.isPressed(params[1]);
                        break;
                    case 1:
                        result = Input.isTriggered(params[1]);
                        break;
                    case 2:
                        result = Input.isRepeated(params[1]);
                        break;
                }
                break;
            case 12: // Script
            try {
                result = !!eval(params[1]);
            } catch (e) {
                console.error(e);
                let eid = this._eventId;
                let nam = $gameMap.event(eid) ? $gameMap.event(eid).event().name : 'undefined';
                let idx = this._index;
                console.error("at Script Call (branch) > eventId : " + eid + " (" + nam + ") " + " index : " + idx);
                if ($gameTemp.isPlaytest()) $gameSwitches.setValue(32, true);        
            }
            break;
            case 13: // Vehicle
                result = $gamePlayer.vehicle() === $gameMap.vehicle(params[1]);
                break;
        }
        this._branch[this._indent] = result;
        if (this._branch[this._indent] === false) {
            this.skipBranch();
        }
        return true;
    };
    
    
    //アニメーションのターゲット存在確認
    const _Game_Temp_requestAnimation = Game_Temp.prototype.requestAnimation;
    Game_Temp.prototype.requestAnimation = function(
        targets, animationId, mirror = false
    ) {
        if (targets) {
            _Game_Temp_requestAnimation.apply(this, arguments);
        }
    };

    //停止時resetPatternの猶予
    Game_CharacterBase.prototype.updatePattern = function() {
        if (!this.hasStepAnime() && this._stopCount > 4) {
            this.resetPattern();
        } else {
            this._pattern = (this._pattern + 1) % this.maxPattern();
        }
    };
    
    //this.character(0)のセーフ機構
    Game_Interpreter.prototype.character = function(param) {
        if ($gameParty.inBattle()) {
            return null;
        } else if (param < 0) {
            console.log('▲this.character(0)の対象がプレイヤーに移りました');
            return $gamePlayer;
        } else if (this.isOnCurrentMap()) {
            //return $gameMap.event(param > 0 ? param : this._eventId);
            return $gameMap.event(param > 0 ? param : $gameMap.event(this._eventId) ? this._eventId : null);
        } else {
            return null;
        }
    };

    // マップシーンでthis.characterの中身がnullになるのを防ぐ
    // 代わりにプレイヤーキャラへ対象変更
    Game_Interpreter.prototype.character = function(param) {
        if ($gameParty.inBattle()) {
            return null;
        //} else if (param < 0) {
        } else if (param < 0 || !param && !this._eventId) {
            return $gamePlayer;
        } else if (this.isOnCurrentMap()) {
            return $gameMap.event(param > 0 ? param : this._eventId);
        } else {
            //return null;
            return $gamePlayer;
        }
    };

    // eraseEventのセーフ機構
    // 対象不適正でもエラー落ちを起こさずスイッチ0001をONにする
    const _Game_Map_eraseEvent = Game_Map.prototype.eraseEvent;
    Game_Map.prototype.eraseEvent = function(eventId) {
        try {
            _Game_Map_eraseEvent.call(this,eventId);
        } catch (error) {
            console.log(error);
            if ($gameTemp.isPlaytest()) $gameSwitches.setValue(1,true);
        }
    };

    // アニメパターン指定
    Game_Interpreter.prototype.setCharacterAnimePattern = function(animePattern) {
        this.character(0)._pattern = this.character(0)._originalPattern = animePattern;
        //this.character(0).refresh();
    };

    Game_CharacterBase.prototype.setSelfCharacterAnimePattern = function(animePattern) {
        this._originalPattern = animePattern;
        this._pattern = animePattern;
        //this.refresh();
    };
    
    //フェード速度の変更
    Scene_Base.prototype.fadeSpeed = function() {
        //return 24;
        return 16;
    };

    //マウス・タッチ操作の全カット
    SceneManager.updateInputData = function() {
        Input.update();
        TouchInput.update();
    };
    
    Scene_Base.prototype.buttonAreaHeight = function() {
        return 0;
    };
    
    //タッチUI用ボタンを表示しない
    Scene_MenuBase.prototype.create = function() {
        Scene_Base.prototype.create.call(this);
        this.createBackground();
        this.updateActor();
        this.createWindowLayer();
        //this.createButtons();
    };
    
    //初期状態のセーブ許可を禁止
    const _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.apply(this, arguments);
        this._saveEnabled = false;
    };
    
    //スローモーション　※要外部スイッチ名制御
    SceneManager.update = function(deltaTime) {
        try {
            let n = this.determineRepeatNumber(deltaTime);
            if ($gameSwitches) {
                if (getSwitch('mapSceneSlowMotion') == true) n = this.determineRepeatNumber(deltaTime/2);
            }
            for (let i = 0; i < n; i++) {
                this.updateMain();
            }
        } catch (e) {
            this.catchException(e);
        }
    };
    
    // このキャラがプレイヤーかイベントかを判定
    Game_Interpreter.prototype.subjectCharacter = function () {
        let chr = $gamePlayer;
        if (this._mapId && this._eventId > 0) {
            chr = this.character(0);
        }
           //console.log('subjectChr:'+chr);
        return chr;
    }
    
    // オプションウィンドウのカスタム   
    Window_Options.prototype.windowWidth = function() {
        //const width = this.maxChoiceWidth() + this.colSpacing() + this.padding * 2;
        //return Math.min(width, Graphics.boxWidth);
        return 400;
    };
    
    Window_Options.prototype.statusWidth = function() {
        return 160;
    };
    
    // 制御文字を解釈するように改修
    /*
    const _Window_Options_drawText = Window_Options.prototype.drawText;
    Window_Options.prototype.drawText = function (text, x, y, maxWidth, align) {
        const convertedText = this.convertEscapeCharacters(text);
        _Window_Options_drawText.call(this, convertedText, x, y, maxWidth, align);
    };
    */
    
    const _Window_Command_drawText = Window_Command.prototype.drawText;
    Window_Command.prototype.drawText = function (text, x, y, maxWidth, align) {
        const convertedText = this.convertEscapeCharacters(text);
        _Window_Command_drawText.call(this, convertedText, x, y, maxWidth, align);
    };

    const _Window_MapName_drawText = Window_MapName.prototype.drawText;
    Window_MapName.prototype.drawText = function (text, x, y, maxWidth, align) {
        const convertedText = this.convertEscapeCharacters(text);
        _Window_MapName_drawText.call(this, convertedText, x, y, maxWidth, align);
    };

    /*
    const _Window_Selectable_drawText = Window_Selectable.prototype.drawText;
    Window_Selectable.prototype.drawText = function (text, x, y, maxWidth, align) {
        const convertedText = this.convertEscapeCharacters(text);
        _Window_Selectable_drawText.call(this, convertedText, x, y, maxWidth, align);
    };
    */

    const _Window_SavefileList_drawTitle = Window_SavefileList.prototype.drawTitle;
    Window_SavefileList.prototype.drawTitle = function(savefileId, x, y) {
        if (savefileId === 0) {
            //this.drawText(TextManager.autosave, x, y, 180);
            this.drawTextEx(TextManager.autosave, x, y, 180); //modified 制御文字に対応
        } else {
            //this.drawText(TextManager.file + " " + savefileId, x, y, 180);
            this.drawTextEx(TextManager.file + " " + savefileId, x, y, 180); //modified 制御文字に対応
        }
    };
    

    // スクロールマージン　Code by やまQ 様（ツクマテ）
    Window_Selectable.prototype.ensureCursorVisible = function(smooth) {
        if (this._cursorAll) {
            this.scrollTo(0, 0);
        } else if (this.innerHeight > 0 && this.row() >= 0) {
            const scrollY = this.scrollY();
            const itemHeight = this.itemHeight(); //♪ 追加
            const itemTop = this.row() * this.itemHeight();
            const itemBottom = itemTop + this.itemHeight();
            const scrollMin = itemBottom - this.innerHeight;
            //console.log(scrollMin); //♪ ｹｽｸｾ
            if (scrollY > itemTop - itemHeight) { //♪ 一行分手前からスクロールさせる
                if (smooth) {
                    this.smoothScrollTo(0, itemTop - itemHeight) ; //♪ 一項目分前
                } else {
                    this.scrollTo(0, itemTop - itemHeight); //♪ 一項目分前
                }
            } else if (scrollY < scrollMin + itemHeight) { //♪ 一行分手前からスクロールさせる
                if (smooth) {
                    this.smoothScrollTo(0, scrollMin + itemHeight); //♪ 一項目分先
                } else {
                    this.scrollTo(0, scrollMin + itemHeight); //♪ 一項目分先
                }
            }
        }
    };
    
    // Menuオープンに制限
    /*
    let _Scene_Map_isMenuCalled = Scene_Map.prototype.isMenuCalled;
    Scene_Map.prototype.isMenuCalled = function() {
        return (getSwitch('banCallingMenu') == false) && (Input.isTriggered("menu") || TouchInput.isCancelled());
    };
    */

    let _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
    Scene_Map.prototype.isMenuEnabled = function() {
        return $gameSystem.isMenuEnabled() && !$gameMap.isEventRunning() && !getSwitch('banCallingMenu');
    };
    
    // メニュー呼び出しの仕様変更
    const _Scene_Map_callMenu = Scene_Map.prototype.callMenu;
    Scene_Map.prototype.callMenu = function() {
        //SoundManager.playOk();
        SoundManager.playBattleStart(); // modified
        SceneManager.push(Scene_Menu);
        Window_MenuCommand.initCommandPosition();
        $gameTemp.clearDestination();
        this._mapNameWindow.hide();
        // this._waitCount = 2;
        this._waitCount = 0;
    };    

    // デバッグ用情報コンソール更新
    Game_Interpreter.prototype.updateInfoWindow = function () {
        let information1 = '';
        let information2 = '';
        let isInBattle = false;
        let string = '';
        let lines = 0;
        isInBattle = $gameSwitches.value(18);
        let ox = $gamePlayer._x;
        let oy = $gamePlayer._y;
        var radius = 5;
        let colorcode = 0;
        let changedColorcode = 14;

        if (isInBattle) {
            let enemies = $gameMap.events().filter(
                event => event.event().meta.ABSenemy > 0
                    && !event.event().meta.ABSweed
                    && (ox - event._x) * (ox - event._x) + (oy - event._y) * (oy - event._y) < radius * radius
            )
            for (const enemy of enemies) {
                //if (!enemy) continue;
                string = '';
                string += '[enemy]\n';
                string += 'Name: ' + $dataEnemies[enemy.event().meta.ABSenemy].name + '\n';
                string += 'HP: ' + (enemy._battler.hp) + ' / ' + $dataEnemies[enemy.event().meta.ABSenemy].params[0] + '\n';
                string += 'States:\n';
                //colorcode = enemy.ABSaffectAluren > 0 ? changedColorcode : 0;
                //string += ' -Aluren: ' + '\x1bc[' + colorcode + ']' + enemy.ABSaffectAluren + '\x1bc[0]\n'; //アリューレン
                //colorcode = enemy.ABSisStun > 0 ? changedColorcode : 0;
                //string += ' -Stuning: ' + '\x1bc[' + colorcode + ']' + enemy.ABSisStun + '\x1bc[0]\n';
                //string += ' -Stun: ' + enemy.ABSstun + ' / ' + $dataEnemies[enemy.event().meta.ABSenemy].params[7] + '\n';
                //string += 'Buffs/Debuffs:\n';
                colorcode = enemy.ABSatk != 0 ? changedColorcode : 0;
                string += ' -atk :' + '\x1bc[' + colorcode + ']' + enemy._battler.atk + '\x1bc[0]\n';
                colorcode = enemy.ABSdef != 0 ? changedColorcode : 0;
                string += ' -def: ' + '\x1bc[' + colorcode + ']' + enemy._battler.def + '\x1bc[0]\n';
                colorcode = enemy.ABSmat != 0 ? changedColorcode : 0;
                string += ' -mat: ' + '\x1bc[' + colorcode + ']' + enemy._battler.mat + '\x1bc[0]\n';
                colorcode = enemy.ABSmdf != 0 ? changedColorcode : 0;
                string += ' -mdf: ' + '\x1bc[' + colorcode + ']' + enemy._battler.mdf + '\x1bc[0]\n';
                colorcode = enemy.ABSagi != 0 ? changedColorcode : 0;
                string += ' -agi: ' + '\x1bc[' + colorcode + ']' + enemy._battler.agi + '\x1bc[0]\n';
                colorcode = enemy.ABSinvincible == true ? changedColorcode : 0;
                string += 'Invincible: ' + enemy.ABSinvincible + '\n';
                string += 'ScreenZ: ' + enemy.screenZ() + '\n';
                string += 'EventID: ' + enemy.eventId() + '\n';
                string += '---------------------------------\n';

                lines = information1.split("\n").length;
                if (lines < 30) {
                    information1 += string;
                } else {
                    information2 += string;
                }
            }
        }

        string = '';
        if ($gamePlayer.isFloating()) {
            string += 'Player Floating: ON\n';
        } else {
            string += 'Player Floating: OFF\n';
        }
        if ($gameMap.isFloatPassableTile($gamePlayer._x,$gamePlayer._y,$gamePlayer._direction,true)) {
            string += 'isFloatPassableTile: true\n';
        } else {
            string += 'isFloatPassableTile: false\n';
        }

        if (window.autoPilot.running === true) {
            string += '\x1bC[6]Auto Pilot: ON\x1bC[0]\n';
            string += Input._currentState['pagedown'] === true ? '\x1bC[1]pagedown\x1bC[0]\n' : '\x1bC[0]pagedown\n';
            string += Input._currentState['attack'] === true ? '\x1bC[1]attack\x1bC[0]\n' : '\x1bC[0]attack\n';
            string += Input._currentState['cancel'] === true ? '\x1bC[1]cancel\x1bC[0]\n' : '\x1bC[0]cancel\n';
            string += Input._currentState['ok'] === true ? '\x1bC[1]ok\x1bC[0]\n' : '\x1bC[0]ok\n';
            string += Input._currentState['up'] === true ? '\x1bC[1]up\x1bC[0]\n' : '\x1bC[0]up\n';
            string += Input._currentState['down'] === true ? '\x1bC[1]down\x1bC[0]\n' : '\x1bC[0]down\n';
            string += Input._currentState['left'] === true ? '\x1bC[1]left\x1bC[0]\n' : '\x1bC[0]left\n';
            string += Input._currentState['right'] === true ? '\x1bC[1]right\x1bC[0]\n' : '\x1bC[0]right\n';
        } else {
            string += 'Auto Pilot: OFF\n';
        }


        information2 += string;
        
        $gameVariables.setValue(68, information1);
        $gameVariables.setValue(69, information2);

    };

    //オートパイロット中に実行速度UP
    const _Scene_Map_updateMainMultiply = Scene_Map.prototype.updateMainMultiply;
    Scene_Map.prototype.updateMainMultiply = function() {
        if (window.autoPilot.running) {
            this.updateMain();
            //this.updateMain();
        }
        _Scene_Map_updateMainMultiply.call(this, arguments);
    };

    //BGM停止にフェードをかける
    AudioManager.playBgm = function (bgm, pos) {
        if (this.isCurrentBgm(bgm)) {
            this.updateBgmParameters(bgm);
        } else {
            if (bgm) {
                //this.stopBgm(); // original
                this.fadeOutBgm(0.5); // modified
                if (bgm.name) {
                    this._bgmBuffer = this.createBuffer("bgm/", bgm.name);
                    this.updateBgmParameters(bgm);
                    if (!this._meBuffer) {
                        this._bgmBuffer.play(true, pos || 0);
                    }
                }

            }
        }
        if (bgm) this.updateCurrentBgm(bgm, pos);
    };

    // オプション音量設定の刻み値を変える
    Window_Options.prototype.volumeOffset = function () {
        //return 20;
        return 5;
    };

    // オートセーブ成功時にスイッチON
    const _Scene_Base_onAutosaveSuccess = Scene_Base.prototype.onAutosaveSuccess;
    Scene_Base.prototype.onAutosaveSuccess = function() {
        _Scene_Base_onAutosaveSuccess.call(this);
        setSwitch('autoSaveSuccess',true);
    };
    
    WindowLayer.prototype.render = PIXI.Container.prototype.render;
    
    //矢が弾かれた処理
    Game_CharacterBase.prototype.isArrowParried = function () {
        let px = Math.floor(this._x);
        let ppx = Math.ceil(this._x);
        let py = Math.ceil(this._y);
        let d = this._direction;
        if (d == 4) {
            if ($gameMap.regionId((px), py) > 0 && $gameMap.regionId((px), py) % 9 == 0) {
                return true;
            }
        }
        if (d == 6) {
            if ($gameMap.regionId((ppx), py) > 0 && $gameMap.regionId((ppx), py) % 9 == 0) {
                return true;
            }
        }
        if (d == 2) {
            if (($gameMap.regionId(px, (py)) > 0 && $gameMap.regionId(px, (py)) % 9 == 0)
                || ($gameMap.regionId(ppx, (py)) > 0 && $gameMap.regionId(ppx, (py)) % 9 == 0)) {
                return true;
            }
        }
        if (d == 8) {
            if (($gameMap.regionId(px, (py)) > 0 && $gameMap.regionId(px, (py)) % 9 == 0)
                || ($gameMap.regionId(ppx, (py)) > 0 && $gameMap.regionId(ppx, (py)) % 9 == 0)) {
                return true;
            }
        }
        return false;
    }

    // 敵HPゲージの値取得用
    function enemyGaugeCurrent() {
        if ($gameSwitches.value(9) && !!$gameMap.event($gameVariables.value(1))) {
            return $gameMap.event($gameVariables.value(1))._battler._hp;
        } else {
            return 0;
        }
    }

    function enemyGaugeMax() {
        if ($gameSwitches.value(9) && !!$gameMap.event($gameVariables.value(1))) {
            return $gameMap.event($gameVariables.value(1))._battler.mhp;
        } else {
            return 1;
        }
    }

    function bossGaugeCurrent() {
        if ($gameSwitches.value(13) && !!$gameMap.event($gameVariables.value(239))) {
            return $gameMap.event($gameVariables.value(239))._battler._hp;
        } else {
            return 0;
        }
    }

    function bossGaugeMax() {
        if ($gameSwitches.value(13) && !!$gameMap.event($gameVariables.value(239))) {
            return $gameMap.event($gameVariables.value(239))._battler.mhp;
        } else {
            return 1;
        }
    }

    window.enemyGaugeCurrent = enemyGaugeCurrent;
    window.enemyGaugeMax = enemyGaugeMax;
    window.bossGaugeCurrent = bossGaugeCurrent;
    window.bossGaugeMax = bossGaugeMax;

    // ステート制御用パラメータ
    let _Game_Actor_initialize = Game_Actor.prototype.initialize;
    Game_Actor.prototype.initialize = function(actorId) {
        _Game_Actor_initialize.call(this, actorId);
        this._ABSstatePts = {
            'poison'    : 0,
            'silence'   : 0,
            'ogrize'    : 0,
            'frost'    : 0,
            'dead'      : 0,
        }
    }

    // シナリオテキスト番号取得用関数
    function sceneStartNo(eventName) {
        return $dataUniques.scnText[$dataUniques.scnText.findIndex(({scene}) => scene === eventName)].start;
    }

    function sceneEndNo(eventName) {
        return $dataUniques.scnText[$dataUniques.scnText.findIndex(({scene}) => scene === eventName)].end;
    }

    function sceneFinishNo(eventName) {
        return $dataUniques.scnText[$dataUniques.scnText.findIndex(({scene}) => scene === eventName)].finish;
    }

    window.sceneStartNo = sceneStartNo;
    window.sceneEndNo   = sceneEndNo;
    window.sceneFinishNo = sceneFinishNo;

    //デッドロック判定
    Game_CharacterBase.prototype.isDeadlocked = function () {
        let px = Math.floor(this._x);
        let ppx = Math.ceil(this._x);
        let py = Math.ceil(this._y);
        if (
            this.isMapPassable(px, py, 2) == false
            && this.isMapPassable(px, py, 4) == false
            && this.isMapPassable(px, py, 6) == false
            && this.isMapPassable(px, py, 8) == false
        ) {
            //console.log('DeadLocked');
            return true;
        }
        if (
            this.isMapPassable(ppx, py, 2) == false
            && this.isMapPassable(ppx, py, 4) == false
            && this.isMapPassable(ppx, py, 6) == false
            && this.isMapPassable(ppx, py, 8) == false
        ) {
            //console.log('DeadLocked');
            return true;
        }
        //console.log('Not DeadLocked');
        return false;
    }

    //向いている前方１マスを取得
    Game_CharacterBase.prototype.frontX = function(d) {
        const x2 = $gameMap.roundXWithDirection(this._x, d);
        return x2;
    }

    Game_CharacterBase.prototype.frontY = function(d) {
        const y2 = $gameMap.roundYWithDirection(this._y, d);
        return y2;
    }

    Game_CharacterBase.prototype.frontDistX = function() {
        let d = this.direction();
        return this.frontX(d) - this._x;
    }

    Game_CharacterBase.prototype.frontDistY = function() {
        let d = this.direction();
        return this.frontY(d) - this._y;
    }

    // _buffsの仕様変更
    const _Game_BattlerBase_paramBuffRate = Game_BattlerBase.prototype.paramBuffRate;
    Game_BattlerBase.prototype.paramBuffRate = function(paramId) {
        // return this._buffs[paramId] * 0.25 + 1.0;
        return this._buffs[paramId];
    };

    const _Game_BattlerBase_param = Game_BattlerBase.prototype.param;
    Game_BattlerBase.prototype.param = function(paramId) {
        const value =
            this.paramBasePlus(paramId) *
            //this.paramRate(paramId) *
            this.paramRate(paramId) +
            this.paramBuffRate(paramId);
        const maxValue = this.paramMax(paramId);
        const minValue = this.paramMin(paramId);
        return Math.round(value.clamp(minValue, maxValue));
    };
    
    // プラグインマネージャーから適用されているプラグイン情報を取得
    function getPluginInfos() {
        const plugins = $plugins;
        const pluginList = [];
      
        // プラグインごとに名前と作者名を取得
        for (const plugin of plugins) {
          //const plugin = $plugins.find(p => p.name === pluginName);
          if (plugin.status) { // 有効なプラグインのみ対象
            const pname = plugin.name;
            const author = plugin.author || "作者不明"; // 作者名を取得（未指定の場合は"作者不明"）
            //console.log('+ '+pname+'/'+author);
            pluginList.push(`${pname}`);
          }
        }
      
        if (pluginList.length > 0) {
          console.log("適用されているプラグイン一覧:");
          console.log(pluginList.join("\n"));
          return pluginList.join("\n");
        } else {
          console.log("適用されているプラグインはありません。");
          return;
        }
    }
    window.getPluginInfos = getPluginInfos;

    // クレジット情報を取得
    function getCreditList(isEnding) {
        const credits = $dataUniques.credits;
        let desc1content = "";
        let desc1appear = "";
        let desc2content = "";
        let desc2appear = "";
        let linkAppear = "";
        let name1appear = "";
        let name2appear = "";
        let contentList = [];
        let indentText = "\x1bPX[50]";
        if (isEnding) {
            for (const credit of credits) {
                if (credit.desc1 && credit.desc1 !== desc1content) {
                    desc1content = credit.desc1;
                    desc1appear = "\n\n\x1bFS[18]" + credit.desc1 + "\x1bFS[22]\n\n";
                } else {
                    desc1appear = "";
                }
                if (credit.desc2 && credit.desc2 !== desc2content) {
                    desc2content = credit.desc2;
                    desc2appear = "\n\n\x1bFS[17]" + credit.desc2 + "\x1bFS[22]\n　";
                } else {
                    desc2appear = "";
                }
                if (credit.link) {
                    linkAppear = "\n　　　　　\x1bFS[18]" + credit.link + "\x1bFS[22]\n";
                } else {
                    linkAppear = "\n";
                }
                if (credit.name1) {
                    name1appear = "\x1bFS[22]" + credit.name1 + "\x1bFS[22]";
                } else {
                    name1appear = "";
                }
                if (credit.name2) {
                    name2appear = "\x1bFS[19]" + credit.name2 + "\x1bFS[22]";
                } else {
                    name2appear = "";
                }
                
                contentList.push(`${desc1appear}　${desc2appear}　　${name1appear}　${name2appear}　${linkAppear}`);
            }
        } else {
            for (const credit of credits) {
                if (credit.desc1 && credit.desc1 !== desc1content) {
                    desc1content = credit.desc1;
                    desc1appear = "\n" + credit.desc1 + "\n";
                } else {
                    desc1appear = "";
                }
                if (credit.desc2 && credit.desc2 !== desc2content) {
                    desc2content = credit.desc2;
                    desc2appear = credit.desc2 + "\n　";
                } else {
                    desc2appear = "";
                }
                if (credit.link) {
                    linkAppear = "\n　　　　　" + credit.link;
                } else {
                    linkAppear = "";
                }
                contentList.push(`${desc1appear}　${desc2appear}　　${credit.name1}　${credit.name2}　${linkAppear}`);
            }

        }
        return contentList.join("\n");

    }
    window.getCreditList = getCreditList;

    //リトライ実行処理
    function executeRetry() {
        // フェードアウト開始
        SceneManager._scene.startFadeOut(30, false); // 30フレーム（約0.5秒）でフェードアウト

        // フェードアウト完了後にセーブデータをロード
        //setTimeout(() => {
            DataManager.loadGame(0).then(() => {
                console.log("セーブデータのロードに成功しました");
                Scene_Load.prototype.onLoadSuccess();

                // システムの初期化のみ実行
                $gameSystem.onAfterLoad();

                /*
                // マップシーンに遷移
                SceneManager.goto(Scene_Map);

                // マップ遷移後に処理を遅延実行してリフレッシュ
                setTimeout(() => {
                    $gamePlayer.reserveTransfer($gameMap.mapId(), $gamePlayer.x, $gamePlayer.y);
                    $gamePlayer.refresh();
                    $gameMap.setup($gameMap.mapId());
                    $gameMap.requestRefresh();

                    // 全イベントをリフレッシュ
                    $gameMap.events().forEach(event => {
                        event.refresh();
                        if (event.isStarting()) {
                            event.clearStartingFlag();  // 並列イベントの開始フラグをリセット
                        }
                    });

                // マップ遷移後にフェードインを開始
                SceneManager._scene.startFadeIn(30, false); // 30フレーム（約0.5秒）でフェードイン

                    console.log("マップとイベントのリフレッシュ完了");

                }, 1); // マップ遷移後100ms遅延して実行
                */
            }).catch((error) => {
                console.error("セーブデータのロードに失敗しました。エラー:", error);
                SceneManager._scene.startFadeIn(30, false); // エラー時にもフェードイン
            });
        //}, 35); // フェードアウト完了後にロード処理を実行
    }
    window.executeRetry = executeRetry
  
    // ロード時かならずマップをリロードするように
    Scene_Load.prototype.onLoadSuccess = function() {
        SoundManager.playLoad();
        this.fadeOutAll();
        this.reloadMapIfUpdated();
        //
        const mapId = $gameMap.mapId();
        const x = $gamePlayer.x;
        const y = $gamePlayer.y;
        const d = $gamePlayer.direction();
        $gamePlayer.reserveTransfer(mapId, x, y, d, 0);
        $gamePlayer.requestMapReload();
        //
        SceneManager.goto(Scene_Map);
        this._loadSuccess = true;
    };

    //ダメージ床無効
    const _Game_Actor_checkFloorEffect = Game_Actor.prototype.checkFloorEffect;
    Game_Actor.prototype.checkFloorEffect = function() {
        return;
        if ($gamePlayer.isOnDamageFloor()) {
            this.executeFloorDamage();
        }
    };
    
    // イベントの更新を限定的にする
    /*
    const UPDATE_INTERVAL = 2;     // 更新間隔（フレーム）
    const ACTIVE_RANGE = 30;        // 判定範囲（タイル単位）
    const TARGET_MAP_ID = 60;       // 対象マップID

    let _frameCount = 0;
    let _activeEvents = [];

    const _Game_Map_updateEvents = Game_Map.prototype.updateEvents;
    Game_Map.prototype.updateEvents = function() {
        $gameVariables._data[251] = 0;

        if (this.mapId() === TARGET_MAP_ID) {
            _frameCount++;

            if (_frameCount % UPDATE_INTERVAL === 0) {
                const playerX = $gamePlayer.x;
                const playerY = $gamePlayer.y;

                _activeEvents = this.events().filter(event => {
                    const dx = Math.abs(event.x - playerX);
                    const dy = Math.abs(event.y - playerY);
                    return dx <= ACTIVE_RANGE && dy <= ACTIVE_RANGE;
                });
                this._activeEvents = _activeEvents;
            }

            for (const event of _activeEvents) {
                event.update();
                $gameVariables._data[251]++;
            }
        } else {
            for (const event of this.events()) {
                event.update();
                $gameVariables._data[251]++;
            }
        }

        for (const commonEvent of this._commonEvents) {
            commonEvent.update();
        }
    };
    */

    /*
    //
    const _Game_CharacterBase_update = Game_CharacterBase.prototype.update;
    Game_CharacterBase.prototype.update = function () {
        if (this._eventId > 0 && this.event().meta.ABSsize > 0) {
            let distX = (Math.abs(this._x - $gamePlayer._x));
            let distY = this._y - $gamePlayer._y;
            if (distX < 1 && distY > 0 && distY <= 2.5) {
                console.log('opacity:on');
                this.setOpacity(160);
            } else if (this._opacity != 255) {
                console.log('opacity:off');
                this.setOpacity(255);
            }
        }
        _Game_CharacterBase_update.call(this);

    }
    */

    // テキストカラー自動判定
    function autoTextColor() {
        const textContent = $externMessage.getValue('scn_text_'+$gameVariables.value(103));
        if (textContent.includes('[ベルナ]') || textContent.includes('[Bellna]')) {
            return '\\C[6]';
        } else if (textContent.includes('[リップ]') || textContent.includes('[Repp]')) {
            return '\\C[4]';
        } else if (textContent.includes('[チェリン]') || textContent.includes('[Cheryn]')) {
            return '\\C[27]';
        } else if (textContent.includes('[スイ]') || textContent.includes('[Suii]')) {
            return '\\C[24]';
        } else if (textContent.includes('[チューチェ]') || textContent.includes('[Chuche]')) {
            return '\\C[2]';
        } else if (textContent.includes('[アールタ]') || textContent.includes('[Arta]')) {
            return '\\C[5]';
        }
    }
    window.autoTextColor = autoTextColor;


    function detectAndProcessString(inputText) {
        const searchWordsMap = {
            'bell_': ['[ベルナ]', '[Bellna]'],  // 'bell_'に対応する検索語
            'repp_': ['[リップ]', '[Repp]'],   // 'repp_'に対応する検索語
            'cher_': ['[チェリン]', '[Cheryn]'],
            'suii_': ['[スイ]', '[Suii]'],
            'chuu_': ['[チューチェ]', '[Chuche]'],
            'arta_': ['[アールタ]', '[Arta]']
        };
    
        let result = '';
        
        // マップの各エントリに対して検索を行う
        for (let detectWord in searchWordsMap) {
            let searchWords = searchWordsMap[detectWord];  // 検索語（配列）
            
            // 各検索語をチェック
            for (let searchWord of searchWords) {
                // 正規表現を使って、検索語がそのままの形式で出現している場合を探す
                let regex = new RegExp(`\\${searchWord}`, 'g');
                let match = inputText.match(regex); // 一致する部分を検索
    
                if (match) {
                    let searchIndex = inputText.indexOf(searchWord);  // 検索語の位置を取得
                    
                    if (searchIndex !== -1) {
                        // 検出語を探す
                        let detectIndex = inputText.indexOf(detectWord, searchIndex); // 検出語の位置を検索語の後に探す
                        
                        if (detectIndex !== -1) {
                            // 検出語の前にある「\FF[」のような文字列を抽出
                            let patternStartIndex = inputText.lastIndexOf("\\", detectIndex);  // 検出語の前にある「\」の位置を取得
                            let pattern = inputText.slice(patternStartIndex, detectIndex);  // パターン部分を取り出す
    
                            // 余分な "[" を取り除き、最終的なフォーマットに合わせる
                            let cleanedPattern = pattern.slice(1, -1);  // 最初の "\" と最後の "]" を削除
    
                            // 結果を整形
                            result = `\\AA[${cleanedPattern}]`; // \AA[FF]の形式に
                            break;  // 最初に見つけた結果を返す
                        }
                    }
                }
            }
    
            if (result) break;  // 結果が見つかればループを抜ける
        }
    
        return result === '' ? ' ' : result;  // 結果を返す
    }
                    
    window.detectAndProcessString = detectAndProcessString;

    /* jumpEx2
    ===================================*/
    Game_CharacterBase.prototype.jumpEx2 = function (baseHeight) {
        if (baseHeight === undefined || baseHeight === null || baseHeight === false) {
            baseHeight = 10;
        }

        this._jumpPeak = Math.floor(baseHeight - this._moveSpeed);
        this._jumpCount = this._jumpPeak * 2;
        //this.resetStopCount();
        //this.straighten();

    };

    // ExternMessaage呼び出しスクリプト簡略化
    function extMsg(str) {
        return $externMessage.getValue(str);
    }
    window.extMsg = extMsg;

    /*
    // マップトラベル地点読み出しスクリプト簡略化
    function warpDest(id) {
        return $dataUniques.destinations[id];
    }
    window.extMsg = warpDest;
    */

    //キャラベースで弾撃ち簡略化
    Game_CharacterBase.prototype.ers = function (idOrName, x, y) {
        if (x === undefined) {
            x = this.frontX(this._direction);
        }
        if (y === undefined) {
            y = this.frontY(this._direction);
        }
        $gameMap.spawnEvent(Game_Interpreter.prototype.getEventIdForEventReSpawn(idOrName, true), x, y, true);
    };

    // 並列コモンイベント負荷測定
    /*
    const _Game_CommonEvent_update = Game_CommonEvent.prototype.update;
    Game_CommonEvent.prototype.update = function () {
        const start = performance.now();                         // 開始時間を記録
        _Game_CommonEvent_update.apply(this, arguments);         // 元の処理を実行
        const elapsed = performance.now() - start;               // 経過時間を計算
        if (elapsed >= 1) {                                      // 1ms以上かかった場合
            console.log(`CommonEvent ID: ${this._commonEventId} took ${elapsed.toFixed(2)} ms`);
        }
    };
    */

    //戦闘不能でステート解除をおこなわない
    const _Game_BattlerBase_die = Game_BattlerBase.prototype.die;
    Game_BattlerBase.prototype.die = function() {
        this._hp = 0;
        //this.clearStates();
        this.clearBuffs();
    };

    // 偏りを抑えた乱数を取り出す関数
    const HISTORY_VAR_ID = 288; // 履歴保存用の変数ID。必要に応じて変更

    window.biasedRandom = function (n) {
        const history = $gameVariables.value(HISTORY_VAR_ID) || {};
        const candidates = Array.from({ length: n }, (_, i) => i);
        const counts = candidates.map(c => history[c] || 0);
        const weights = counts.map(c => 1 / (1 + c));
        const total = weights.reduce((a, b) => a + b, 0);
        const normalized = weights.map(w => w / total);

        let r = Math.random();
        let accum = 0;
        for (let i = 0; i < n; i++) {
            accum += normalized[i];
            if (r <= accum) {
                const selected = i;
                history[selected] = (history[selected] || 0) + 1;
                $gameVariables.setValue(HISTORY_VAR_ID, history);
                return selected;
            }
        }

        return n - 1;
    };

    // 偏りを抑制したrandomIntのオーバーライド
    const HISTORY_LIMIT = 20;
    const MAX_HISTORY_PER_RANGE = 5;
    const _randomHistory = {};

    Math.randomInt = function (max) {
        if (!_randomHistory[max]) _randomHistory[max] = [];

        const history = _randomHistory[max];
        const counts = Array.from({ length: max }, (_, i) =>
            history.filter(v => v === i).length
        );
        const weights = counts.map(c => 1 / (1 + c));
        const total = weights.reduce((a, b) => a + b, 0);
        const normalized = weights.map(w => w / total);

        let r = Math.random();
        let accum = 0;
        let selected = max - 1;

        for (let i = 0; i < max; i++) {
            accum += normalized[i];
            if (r <= accum) {
                selected = i;
                break;
            }
        }

        // 更新
        history.push(selected);
        if (history.length > HISTORY_LIMIT) history.shift();

        return selected;
    };

    // 文章のスクロールの早送りをスピードアップ
    Window_ScrollText.prototype.fastForwardRate = function () {
        return 8;
    };

})();

