/*:
* @plugindesc イベントCG用ピクチャ簡易表示機能
* @author Perutan
* @target MZ
*
*
* @param 開始ピクチャID
* @desc 
* @type number
* @default 50
*
* @param 差分表示フェード時間変数ID
* @desc 
* @type variable
* @default 1
*
* @param 背景ファイル名
* @desc 一律でバックに表示するファイルを指定
* @type file
* @dir img/pictures
*
* @param 背景不透明度
* @desc 背景画像の不透明度
* @type number
* @default 255
*
* @param 背景ピクチャID
* @desc 背景画像のピクチャID
* @type number
* @default 40
*
*
* @command ShowStilPicture
* @text ピクチャ表示
* @desc 指定したパラメータでピクチャを表示
*
* @arg name
* @text ファイル名
* @desc 表示するファイルを指定
* @type file
* @dir img/pictures
*
* @arg pictX
* @text 左右位置
* @desc 表示するX座標を指定（左上）
* @type number
* @default 0
*
* @arg duration
* @text 時間
* @desc 差分が表示されるまでかける時間
* @type number
*
*
* @command EraseStilPicture
* @text ピクチャ消去
* @desc 指定したピクチャを消去
*
*
*/

(function () {
    'use strict'

    //=============================================================================
    // プラグインパラメータの取得
    //=============================================================================

    var pluginName = 'PRTN_PictControlForStil';
    var parameters = PluginManager.parameters('PRTN_PictControlForStil');
    var PRTNstartPictId = Number(parameters['開始ピクチャID']);
    var PRTNstilPictureDefaultDurationVarId = Number(parameters['差分表示フェード時間変数ID']);
    var PRTNbgName = String(parameters['背景ファイル名']);
    var PRTNbgOpacity = Number(parameters['背景不透明度']);
    var PRTNbgPictId = Number(parameters['背景ピクチャID']);



    //=============================================================================
    // プラグインコマンド
    //=============================================================================

    // for MV (code356)
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
  
      if (command === 'ShowStilPicture') {
        var argParams = {
          "name": args[0],
          "pictX": args[1],
          "duration": args[2],
        };
        this.PRTN_ShowStilPicture(argParams);
      }
  
      if (command === 'EraseStilPicture') {
        var argParams = {
        };
        this.PRTN_EraseStilPicture(argParams);
      }  
    }
  
    // for MZ (code357)
    PluginManager.registerCommand(pluginName, "ShowStilPicture", function (args) {
        this.PRTN_ShowStilPicture(args);
    });

    PluginManager.registerCommand(pluginName, "EraseStilPicture", function () {
        this.PRTN_EraseStilPicture();
    });


    //=============================================================================
    // 実行用の関数
    //=============================================================================

    let PRTN_StilPictures = [];

    Game_Interpreter.prototype.PRTN_ShowStilPicture = function (args) {
        var name = String(args.name);
        var x = Number(args.pictX) || 0;
        var duration = Number(args.duration) || $gameVariables.value(PRTNstilPictureDefaultDurationVarId);

        ImageManager.loadPicture(name);

        if (x == undefined) x = 0;
        if (duration == undefined) duration = 20;

        // MessageSkip.js によるスキップ中はフェードを省略
        if ($gameMessage.skipFlg()) {
            duration = 1;
        }

        /*
        if (PRTN_StilPictures.length <= 1) {
            var pictureId = PRTNstartPictId + PRTN_StilPictures.length;
            var params1 = [pictureId, name, 0, 0, x, 0, 100, 100, 0, 0];
            this.command231(params1); // Show Picture
            var params2 = [pictureId, name, 0, 0, x, 0, 100, 100, 255, 0, duration, false, 1];
            this.command232(params2); // Move Picture  
            PRTN_StilPictures.push(pictureId);
        } else {
            var pictureId = PRTNstartPictId;
            var params1 = [pictureId, name, 0, 0, x, 0, 100, 100, 255, 0];
            this.command231(params1); // Show Picture
            // pictureId, name, origin, pointType, x, y, scaleX, scaleY, opacity, blendMode, duration, wait, easingType
            var params2 = [pictureId + 1, name, 0, 0, x, 0, 100, 100, 0, 0, duration, false, 1];
            this.command232(params2); // Move Picture
            this.command235(params2); // Erase Picture
            PRTN_StilPictures.pop();
        }
        if ($gameTemp.isPlaytest()) console.log(PRTN_StilPictures);
        */

        // pictureId, name, origin, pointType, x, y, scaleX, scaleY, opacity, blendMode, duration, wait, easingType

        if (PRTNbgName) {
            var BgParams = [PRTNbgPictId, PRTNbgName, 0, 0, 0, 0, 100, 100, PRTNbgOpacity, 0];
            this.command231(BgParams); // Show Picture
        }

        if (PRTN_StilPictures.length == 0) {
            var pictureId = PRTNstartPictId;
            var params1 = [pictureId, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 0, 0];
            this.command231(params1); // Show Picture
            var params2 = [pictureId, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 255, 0, duration, false, 1];
            this.command232(params2); // Move Picture
            var params3 = [pictureId + 1, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 0, 0, duration * 2, false, 1];
            this.command232(params3); // Move Picture
            PRTN_StilPictures.push(pictureId);
        } else {
            var pictureId = PRTNstartPictId + 1;
            var params1 = [pictureId, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 0, 0];
            this.command231(params1); // Show Picture
            var params2 = [pictureId, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 255, 0, duration, false, 1];
            this.command232(params2); // Move Picture  
            var params3 = [pictureId - 1, name, 1, 0, x+Graphics.width/2, Graphics.height/2, 100, 100, 0, 0, duration * 2, false, 1];
            this.command232(params3); // Move Picture
            //this.command235(params2); // Erase Picture
            PRTN_StilPictures.pop();
        }
        if ($gameTemp.isPlaytest()) console.log(PRTN_StilPictures);             
    }

    Game_Interpreter.prototype.PRTN_EraseStilPicture = function () {
        var BgParams = [PRTNbgPictId];
        this.command235(BgParams); // Erase Picture

        for (var i = 0; i < 3; i++) {
            var params = [PRTNstartPictId + i];
            this.command235(params); // Erase Picture
        }
        while (PRTN_StilPictures.length) {PRTN_StilPictures.pop()};
    }

})();
