/*:
 * @plugindesc ユニークピクチャIDを使ったピクチャ管理プラグイン
 * @target MZ
 * @help
 * このプラグインは、ユニークな名前でピクチャIDにアクセスする方法を提供します。
 */

(() => {
    // グローバルピクチャIDマップ
    const PictureMap = {
        "gaugeStandPictBack": 1,
        "gaugeStandPictFront": 2,
        "eventBgLower": 20,
        "eventBgUpper": 21,
        "eventStilBg": 49,
        "eventStilA": 50,
        "eventStilB": 51,
        "eventStilC": 52,
        "xrayPicture": 55,
        "signOgrizeAvailable": 60,
        "signKagoAvailable": 61,
        "signMapAvailable": 62,
        "floorNameDisplay": 70,
        "eventKeyGuide": 80,
        "mapKeyGuide": 85,
        "mapKeyGuideAIcon": 86,
        "mapKeyGuideBIcon": 87,
        "mapKeyGuideXIcon": 88,
        "mapKeyGuideYIcon": 89,
        "mapKeyGuideA": 90,
        "mapKeyGuideB": 91,
        "mapKeyGuideX": 92,
        "mapKeyGuideY": 93,
        "mapKeyGuideLBIcon": 81,
        "mapKeyGuideRBIcon": 82,
        "mapKeyGuideLTIcon": 83,
        "mapKeyGuideRTIcon": 84,
        "pharmacistWindowStrings": 71,
        "mapKeyGuideLB": 94,
        "mapKeyGuideRB": 95,
        "mapKeyGuideLT": 96,
        "mapKeyGuideRT": 97,
        "autoSaveAppearance": 99,
    };

    // ピクチャIDをユニークネームで取得する関数
    function getPictureId(name) {
        return PictureMap[name];
    }

    // ピクチャオブジェクトをユニークネームで取得する関数
    function getPicture(name) {
        const id = getPictureId(name);
        return $gameScreen.picture(id);
    }

    // これらの関数をグローバルにアクセスできるようにします
    window.getPictureId = getPictureId;
    window.getPicture = getPicture;
})();
