/*:
* @plugindesc 簡易ボイス再生
* @author Perutan
* @target MZ
*
*
*
*
*/

(function () {
    'use strict'

    //=============================================================================
    // プラグインパラメータの取得
    //=============================================================================
    var pluginName = 'PRTN_PlayVoice';
    var parameters = PluginManager.parameters('PRTN_PlayVoice');

    var voiceSpeecher = '';
    var voiceNum = '';
    var speecherVar = 0;
    var voiceVolume = 90;
    var voiceSpeecherArgs = {};

    //=============================================================================
    // ボイス再生簡略化
    //=============================================================================

    var _Window_Base_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
    Window_Base.prototype.convertEscapeCharacters = function(text) {
        text = _Window_Base_convertEscapeCharacters.apply(this, arguments);
        text = text.replace(/\x1bvo\[(\w*)]/gi,  function (_, p1) {
            Game_Interpreter.prototype.executePlayVoice(String(p1));
            return '';
        });
        //console.log(text);
        return text;
    };

    Game_Interpreter.prototype.executePlayVoice = function (num) {
        if (!num) return;
        voiceNum = String(num);
        switch (voiceSpeecher) {
            default:
                voiceSpeecher = '';
                speecherVar = 0;
                voiceVolume = 100;
        }
        if (voiceSpeecher) {
            speecherVar = voiceSpeecherArgs[voiceSpeecher].speecherVar;
            voiceVolume = voiceSpeecherArgs[voiceSpeecher].volume;
        }
        if (voiceNum != '000') this.playVo(String(voiceSpeecher), String(voiceNum), String(voiceVolume));
        return;
    };

    Game_Interpreter.prototype.playVo = function (name, number, vol) {
        if (this.isVoicePlayable(speecherVar,number)) {
            var args = [String(name) + String(number), String(vol), "100", "0"];
            console.log(args);
            this.pluginCommand("PlayCV", args);
        } else {
            this.pluginCommand("StopCV");
        }
        
        console.log(AudioManager._voiceBuffers);
        //console.log(this.voiceDuration());
    };

    Game_Interpreter.prototype.isVoicePlayable = function (index,sub) {
        return true;
        let sw1 = 226;
        let sw2 = 227;
        let result = 0;
        let strList1 = ['zira','merc','thal','wolf'];
        for (let index = 0; index < strList1.length; index ++) {
            if (sub.includes(strList1[index])) {
                if ($gameSwitches.value(sw2)) {
                    result += 1;
                } else {
                    return false;
                }
            }
        }
        if (result == 0 && $gameSwitches.value(sw1)) result += 1;
        return (result > 0);
    };


    //=============================================================================
    // MessageSkip.js
    //=============================================================================

    var _Window_Message_isTriggered = Window_Message.prototype.isTriggered;
    Window_Message.prototype.isTriggered = function () {
        if (this.isTriggeredMessageSkipButton() || this.isTriggeredMessageAutoButton()) {
            return false;
        }
        if (this.messageAuto() && this._messageAutoCount <= 0) {
            if (AudioManager._cvBuffers[0] && AudioManager._cvBuffers[0].isPlaying() === true) { // modified
                return false;
            } else {
                this.initializeMessageAutoCount();
                return true;
            }
        }
        return _Window_Message_isTriggered.apply(this, arguments) || this.messageSkip();
    };

    //=============================================================================
    // rmmz_windows.js
    //=============================================================================

    var _Window_Message_terminateMessage = Window_Message.prototype.terminateMessage;
    Window_Message.prototype.terminateMessage = function () {
        console.log('GO');
        _Window_Message_terminateMessage.call(this);
        AudioManager.stopCv();
    };
    



})();