/*:
 * @target MZ
 * @plugindesc 指定された角度と半径の範囲内にプレイヤーが存在するかを判定するプラグイン
 * @help
 * このプラグインは、Game_CharacterBaseクラスにプレイヤーが指定された角度と
 * 半径の範囲内に存在するかを判定する関数を追加します。
 *
 * 使用方法:
 * イベントコマンドのスクリプトエディタで以下のように使用できます。
 *
 * if (this.isPlayerInRange(90, 5)) {
 *     console.log("プレイヤーが範囲内にいます");
 * } else {
 *     console.log("プレイヤーが範囲外です");
 * }
 */

(() => {
    Game_CharacterBase.prototype.isPlayerInRange = function(angle, radius) {
        if ($gameVariables.value(262) > 0) return;
        const player = $gamePlayer;
        const dx = player.x - this.x;
        const dy = player.y - this.y;
        const distance = Math.sqrt(dx * dx + dy * dy);
        
        if (distance > radius) {
            return false;
        }
        
        let theta = Math.atan2(dy, dx) * (180 / Math.PI);
        theta = (theta + 360) % 360;  // 角度を0～360度に調整
        
        let directionAngle;
        switch (this.direction()) {
            case 2: // 下
                directionAngle = 90;
                break;
            case 4: // 左
                directionAngle = 180;
                break;
            case 6: // 右
                directionAngle = 0;
                break;
            case 8: // 上
                directionAngle = 270;
                break;
            default:
                return false;
        }
        
        const diff = Math.abs(directionAngle - theta);
        return diff <= angle / 2 || diff >= 360 - angle / 2;
    };
})();
