/*:
* @plugindesc 歩行グラ簡易6フレーム化
* @target MZ
* @author Perutan（けんせい）
* @url http://twitter.com/kensei1203
*
*
* @param Switch ID
* @desc スイッチIDがONの時に有効
* @type switch
* @default 1
*
* @param EnableWithoutDashing
* @desc 非ダッシュ時にも有効にするかどうか（アクターのみ）
* @type boolean
* @default true
*
* @param SteppingHeight
* @desc 跳ねるコマでの高さ（ピクセル）
* @type number
* @default 4
*
* @param SteppingPitch
* @desc 横方向の移動量（ピクセル）
* @type number
* @default 4
*
* @param SideSteppingDegree
* @desc 横移動時の傾き（角度）
* @type number
* @default 4
*
* @param ParameterRateWithDashing
* @desc ダッシュ時のパラメーター適用倍率（％）
* @type number
* @default 200
*
* @help
* Version 1.0.0
* Released under MIT license
*
*/

(function () {
    'use strict'

    //=============================================================================
    // プラグインパラメータの取得
    //=============================================================================
    var pluginName = 'PRTN_SimpleSixFrames';
    var parameters = PluginManager.parameters('PRTN_SimpleSixFrames');
    var SsfEnableSwId = Number(parameters['Switch ID']);
    var SsfEnableWithoutDashing = eval(parameters['EnableWithoutDashing']);
    var SsfSteppingHeight = Number(parameters['SteppingHeight'] || 4);
    var SsfSteppingPitch = Number(parameters['SteppingPitch'] || 4);
    var SsfSideSteppingDegree = Number(parameters['SideSteppingDegree'] || 4);
    var SsfParameterRateWithDashing = Number(parameters['ParameterRateWithDashing'] || 200);

    //=============================================================================
    // Game_CharacterBase
    //=============================================================================

    Game_CharacterBase.prototype.isSimpleSixFrames = function () {
        if ($gameSwitches.value(SsfEnableSwId) && this.hasSimpleSixFramesMeta()) {
            if (SsfEnableWithoutDashing === true) {
                return true;
            } else {
                return this._eventId > 0 || this.isDashing();
            }
        }
        return false;
    };

    Game_CharacterBase.prototype.hasSimpleSixFramesMeta = function () {
        if (!this._eventId > 0) {
            var mi = this._memberIndex > 0 ? this._memberIndex : 0;
            var actor = $gameParty._actors[mi];
            if (actor) return $dataActors[actor].meta['SixFrames'];
        } else {
            if (!!this.event()) {
                return this.event().meta['SixFrames'];   
            }
        }
    };

    var _Game_CharacterBase_prototype_animationWait = Game_CharacterBase.prototype.animationWait;
    Game_CharacterBase.prototype.animationWait = function () {
        if (this.isSimpleSixFrames()) {
            return (7.5 - this.realMoveSpeed()) * 3;
        } else {
            return _Game_CharacterBase_prototype_animationWait.call(this);
        }
    };

    var _Game_CharacterBase_prototype_maxPattern = Game_CharacterBase.prototype.maxPattern;
    Game_CharacterBase.prototype.maxPattern = function () {
        if (this.isSimpleSixFrames()) {
            return 6;
        } else {
            return _Game_CharacterBase_prototype_maxPattern.call(this);
        }
    };

    var _Game_CharacterBase_prototype_pattern = Game_CharacterBase.prototype.pattern;
    Game_CharacterBase.prototype.pattern = function () {
        if (this.isSimpleSixFrames()) {
            return this._pattern < 6 ? this._pattern : 0;
        } else {
            return _Game_CharacterBase_prototype_pattern.call(this);
        }
    };

    //=============================================================================
    // Sprite_Character
    //=============================================================================

    var _Sprite_Character_prototype_updatePosition = Sprite_Character.prototype.updatePosition;
    Sprite_Character.prototype.updatePosition = function () {
        _Sprite_Character_prototype_updatePosition.call(this);
        if (this._character.isSimpleSixFrames()) {
            if (((this._character.pattern() === 2 || this._character.pattern() === 5) && !this._character._isMultiFrame)
            || ((this._character.pattern() === 1 || this._character.pattern() === 4) && this._character._isMultiFrame)) {
                this.y -= this._character.isDashing() === true || (this._character._memberIndex > 0 && $gamePlayer.isDashing()) ? SsfSteppingHeight * SsfParameterRateWithDashing / 100 : SsfSteppingHeight;
                //this.scale.y *= 0.92;
            }
            if (this._character.pattern() === 2 || this._character.pattern() === 5 || this._character.pattern() === 3 || this._character.pattern() === 0) {
                //this.scale.y *= 0.92
                if (this._character._direction === 4) {
                    this.x -= this._character.isDashing() === true ? SsfSteppingPitch * SsfParameterRateWithDashing / 100 : SsfSteppingPitch;
                }
                if (this._character._direction === 6) {
                    this.x += this._character.isDashing() === true ? SsfSteppingPitch * SsfParameterRateWithDashing / 100 : SsfSteppingPitch;
                }
            }

            if (SsfSideSteppingDegree !== 0) {
                var dg = this._character.isDashing() === true || (this._character._memberIndex > 0 && $gamePlayer.isDashing()) ? SsfSideSteppingDegree * SsfParameterRateWithDashing / 100 : SsfSideSteppingDegree;
                if ((this._character.isMoving() || this._character.PrevMoving) && (this._character._direction === 4)) {
                    this.rotation = (-1 * dg) * Math.PI / 180;
                }
                if ((this._character.isMoving() || this._character.PrevMoving) && (this._character._direction === 6)) {
                    this.rotation = dg * Math.PI / 180;
                }
                if (((this._character._direction !== 4 && this._character._direction !== 6) || (this._character.isMoving() === false && this._character.PrevMoving === false)) && this.rotation !== 0 * Math.PI / 180) {
                    this.rotation = 0;
                }
            }
        }
        if (this._character.isMoving()) {
            this._character.PrevMoving = true;
        } else {
            this._character.PrevMoving = false;
        }
    };

    var _Sprite_Character_prototype_characterPatternX = Sprite_Character.prototype.characterPatternX;
    Sprite_Character.prototype.characterPatternX = function () {
        if (this._character.isSimpleSixFrames()) {
            var sixPatterns = this._character._isMultiFrame ? [0,1,1,2,3,3] : [0, 1, 2, 2, 1, 0];
            return sixPatterns[this._character.pattern()];
        } else {
            return _Sprite_Character_prototype_characterPatternX.call(this);
        }

    };

})();
