/*:
 * @plugindesc ユニーク変数名を使ったゲーム変数管理プラグイン
 * @help
 * このプラグインは、ユニークな名前でゲーム変数にアクセスする方法を提供します。
 */

// グローバル変数マップ
var VariableMap = {
    "enemyEventId": 1,
    "pictureCall": 105,
    "keyIdleCount": 123,
    "keyToDetermine": 130,
    "keyUiOriginX": 124,
    "keyUiOriginY": 125,
    "buttonA": 126,
    "buttonB": 127,
    "buttonX": 128,
    "buttonY": 129,
    "buttonAIcon": 135,
    "buttonBIcon": 136,
    "buttonXIcon": 137,
    "buttonYIcon": 138,
    "buttonLB": 189,
    "buttonRB": 190,
    "buttonLT": 191,
    "buttonRT": 192,
    "buttonLBIcon": 185,
    "buttonRBIcon": 186,
    "buttonLTIcon": 187,
    "buttonRTIcon": 188,
    "returnedIconId": 131,
    "mapKeyGuideDescription": 132,
    "eventKeyGuideDescription": 122,
    "menuKeyGuideDescription": 134,
    "xrayPictureParams": 106,
    "actorStatePoison": 161,
    "actorStateSilence": 162,
    "actorStateOgrize": 163,
    "actorStateDead": 164,
    "actorStateFrost": 177,
    "triggerTargetId": 183,
    "currentTextNo": 103,
    "finishTextNo": 107,
    "finishMeterOpacity": 108,
    "finishCounter": 109,
    "finishCountStartNo": 110,
    "gallerySelectedObject": 202,
    "galleryUnlockArr": 203,
    "galleryThumbnailScale": 204,
    "inBattleTimer": 77,
    "spawnEnemy": 93,
};

// グローバルスイッチマップ
var SwitchMap = {
    "mapSceneSlowMotion": 33,
    "banCallingMenu": 34,
    "autoSaveSuccess": 35,
    "autoSaveAppearance": 36,
    "isInBattle": 18,
};

// 変数取得関数
function getVariable(name) {
    var id = VariableMap[name];
    return $gameVariables.value(id);
}

// 変数設定関数
function setVariable(name, value) {
    var id = VariableMap[name];
    $gameVariables.setValue(id, value);
}

// スイッチ取得関数
function getSwitch(name) {
    var id = SwitchMap[name];
    return $gameSwitches.value(id);
}

// スイッチ設定関数
function setSwitch(name, value) {
    var id = SwitchMap[name];
    $gameSwitches.setValue(id, value);
}