/*:
 * @target MZ
 * @plugindesc Player trail effect plugin
 * @author [Your Name]
 *
 * @param Color Tone
 * @desc Color tone of the trail effect (in r,g,b,a format)
 * @type string
 * @default 255,0,0,128
 *
 * @help PlayerTrail.js
 *
 * This plugin adds a trail effect behind the player character
 * on the map scene.
 *
 * Plugin Command:
 *   TrailOn      # Turn on the trail effect
 *   TrailOff     # Turn off the trail effect
 */

(() => {
    const pluginName = 'PlayerTrail';
    const params = PluginManager.parameters(pluginName);
    const colorTone = params['Color Tone'].split(',').map(Number);
  
    let trailEnabled = false;
  
    // Draw the player trail effect
    function showPlayerTrail() {
      const player = $gamePlayer;
      const map = $gameMap;
      const bitmap = SceneManager._scene._spriteset._baseSprite.bitmap;
      const color = ColorManager.textColor(0);
      const sprite = new Sprite();
      const width = bitmap.width;
      const height = bitmap.height;
      const x = player.screenX();
      const y = player.screenY();
  
      sprite.bitmap = bitmap.clone();
      sprite.opacity = 128;
      sprite.colorTone = colorTone;
  
      const context = sprite.bitmap._context;
      context.save();
      context.globalCompositeOperation = 'lighter';
      context.globalAlpha = 0.1;
  
      for (let i = 0; i < 20; i++) {
        const randX = Math.floor(Math.random() * 41) - 20;
        const randY = Math.floor(Math.random() * 41) - 20;
        const offsetX = x + randX - width / 2;
        const offsetY = y + randY - height / 2;
  
        sprite.move(offsetX, offsetY);
        sprite._color = color;
  
        sprite.drawLightness(0, 0, width, height, -10);
      }
  
      context.restore();
      SceneManager._scene.addChild(sprite);
    }
  
    // Remove the player trail effect
    function hidePlayerTrail() {
      const sprites = SceneManager._scene.children;
      for (const sprite of sprites) {
        if (sprite._color) {
          SceneManager._scene.removeChild(sprite);
        }
      }
    }
  
    // Parse plugin command
    PluginManager.registerCommand(pluginName, 'TrailOn', () => {
      trailEnabled = true;
    });
  
    PluginManager.registerCommand(pluginName, 'TrailOff', () => {
      trailEnabled = false;
      hidePlayerTrail();
    });
  
    // Update the player trail effect every frame
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
      _Scene_Map_update.call(this);
  
      if (trailEnabled && !this.isBusy()) {
        showPlayerTrail();
      }
    };
  })();
  