// Game_CharacterBaseオブジェクトをラップするProxy
(function() {
    const original_initialize = Game_CharacterBase.prototype.initialize;

    // オブジェクトの初期化時にProxyを適用する
    Game_CharacterBase.prototype.initialize = function() {
        original_initialize.call(this);
        
        // thisをProxyでラップして返す
        return new Proxy(this, {
            get: (target, prop) => {
                // プロパティが存在しない場合はundefinedを返す
                if (prop in target) {
                    return target[prop];
                } else {
                    console.warn(`未定義のプロパティ参照: ${prop}`);
                    return undefined; // ここでnullやundefinedを返す
                }
            },
            apply: (target, thisArg, argumentsList) => {
                // メソッドが存在しない場合もundefinedを返す
                if (typeof target[prop] === 'function') {
                    return target[prop].apply(thisArg, argumentsList);
                } else {
                    console.warn(`未定義のメソッド呼び出し: ${prop}`);
                    return undefined; // メソッドが存在しない場合も安全に処理
                }
            }
        });
    };
})();
