/*:
 * @target MZ
 * @plugindesc 移動ルート詰まり防止パッチ（スキップ不可・ウェイト有に限定）@SafeMoveRoutePatch
 */

(() => {
    const TIMEOUT_FRAMES = 120;
  
    const _Game_Character_initMembers = Game_Character.prototype.initMembers;
    Game_Character.prototype.initMembers = function () {
      _Game_Character_initMembers.call(this);
      this._stuckMoveIndex = -1;
      this._stuckFrameCount = 0;
    };
  
    const _Game_Character_updateRoutineMove = Game_Character.prototype.updateRoutineMove;
    Game_Character.prototype.updateRoutineMove = function () {
      const route = this._moveRoute;
      const index = this._moveRouteIndex;
      const list = route?.list;
  
      if (route && list && index < list.length) {
        const command = list[index];
        if (!route.skippable && route.wait && command.code >= 1 && command.code <= 14) {
          if (!this.isMoving()) {
            if (this._stuckMoveIndex === index) {
              this._stuckFrameCount++;
              if (this._stuckFrameCount >= TIMEOUT_FRAMES) {
                console.warn(`[SafeMoveRoutePatch] Event ${this.eventId?.() ?? "player"}: movement stuck, skipping index ${index}`);
                this._moveRouteIndex++;
                this._stuckFrameCount = 0;
                this._stuckMoveIndex = -1;
                return; // スキップ後に通常更新へ
              }
            } else {
              this._stuckMoveIndex = index;
              this._stuckFrameCount = 0;
            }
          } else {
            this._stuckFrameCount = 0;
            this._stuckMoveIndex = -1;
          }
        } else {
          this._stuckFrameCount = 0;
          this._stuckMoveIndex = -1;
        }
      } else {
        this._stuckFrameCount = 0;
        this._stuckMoveIndex = -1;
      }
  
      _Game_Character_updateRoutineMove.call(this);
    };
  })();
  