(() => {
    const TARGET_MAP_ID = 60;
    const ACTIVE_RANGE = 30;
    const UPDATE_INTERVAL = 2;

    let _frameCount = 0;

    // 論理処理の最適化
    const _Game_Map_updateEvents = Game_Map.prototype.updateEvents;
    Game_Map.prototype.updateEvents = function() {
        $gameVariables._data[251] = 0;

        if (this.mapId() === TARGET_MAP_ID) {
            _frameCount++;

            if (_frameCount % UPDATE_INTERVAL === 0 || !this._activeEvents) {
                const playerX = $gamePlayer.x;
                const playerY = $gamePlayer.y;

                this._activeEvents = this.events().filter(event => {
                    const dx = Math.abs(event.x - playerX);
                    const dy = Math.abs(event.y - playerY);
                    return dx <= ACTIVE_RANGE && dy <= ACTIVE_RANGE;
                });
            }

            for (const event of this._activeEvents || []) {
                event.update();
                $gameVariables._data[251]++;
            }
        } else {
            for (const event of this.events()) {
                event.update();
                $gameVariables._data[251]++;
            }
        }

        for (const commonEvent of this._commonEvents) {
            commonEvent.update();
        }
    };

    // スプライト：イベントの更新制御（Z順維持）
    const _Sprite_Character_update = Sprite_Character.prototype.update;
    Sprite_Character.prototype.update = function() {
        const c = this._character;

        const isOutOfRange =
            $gameMap.mapId() === TARGET_MAP_ID &&
            c instanceof Game_Event &&
            !($gameMap._activeEvents || []).includes(c);

        if (isOutOfRange) {
            this.visible = false;
            this.updatePosition(); // ← Z順などを更新（正しい）
            return;
        }

        this.visible = true;
        _Sprite_Character_update.call(this);
    };

    // 影スプライトも同様に
    const _Sprite_Shadow_update = SimpleShadow.Sprite_Shadow.prototype.update;
    SimpleShadow.Sprite_Shadow.prototype.update = function() {
        const c = this._character;

        const isOutOfRange =
            $gameMap.mapId() === TARGET_MAP_ID &&
            c instanceof Game_Event &&
            !($gameMap._activeEvents || []).includes(c);

        if (isOutOfRange) {
            this.visible = false;
            this.updatePosition(); // ← Z順・座標更新あり
            return;
        }

        this.visible = true;
        _Sprite_Shadow_update.call(this);
    };
})();
