/*:
 * @target MZ
 * @plugindesc Show map name when a specified variable changes.
 * @help This plugin allows the map name to be displayed when a specified variable changes.
 *
 * @param VariableID
 * @text Variable ID
 * @desc The ID of the variable to watch for changes.
 * @type variable
 * @default 1
 */

(() => {
    const parameters = PluginManager.parameters('ShowMapNameOnVariableChange');
    const watchVariableId = Number(parameters['VariableID'] || 1);
    let lastMapId = 0;
    let isMapTransfer = false;

    const _Game_Variables_setValue = Game_Variables.prototype.setValue;
    Game_Variables.prototype.setValue = function(variableId, value) {
        const oldValue = this.value(variableId);
        _Game_Variables_setValue.call(this, variableId, value);
        if (variableId === watchVariableId && oldValue !== value && !isMapTransfer) {
            console.log("Variable value changed. Requesting map name display...");
            $gameTemp.requestMapNameDisplay = true;
        }
    };

    const _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function(mapId) {
        if (mapId !== lastMapId) {
            isMapTransfer = true; // Set map transfer flag before setup
            console.log("Starting new map. Resetting watch variable...");
            $gameVariables.setValue(watchVariableId, '');
            lastMapId = mapId;
        }
        _Game_Map_setup.call(this, mapId);
        if ($dataMap.displayName !== '') {
            $gameVariables.setValue(watchVariableId, $dataMap.displayName);
        }
        isMapTransfer = false; // Reset map transfer flag after setup
    };

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        if ($gameTemp.requestMapNameDisplay) {
            console.log("Request to display map name received. Refreshing map name window...");
            this._mapNameWindow.refresh();
            this._mapNameWindow.open();
            $gameTemp.requestMapNameDisplay = false; // Reset the flag
        }
    };

    const _Game_Map_displayName = Game_Map.prototype.displayName;
    Game_Map.prototype.displayName = function() {
        const variableValue = $gameVariables.value(watchVariableId);
        return variableValue || _Game_Map_displayName.call(this);
    };
})();
