/*:
 * @target MZ
 * @plugindesc 自動操縦プラグイン（F7キーでON/OFF切り替え、修正と追加機能）
 * @help このプラグインは、自動操縦によりゲームをプレイする機能を提供します。
 */

(() => {
    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function(sceneActive) {
        _Game_Player_update.call(this, sceneActive);
        if (window.autoPilot && window.autoPilot.running) {
            window.autoPilot.update(this);
        }
    };

    window.autoPilot = {
        running: false,
        currentGoalIndex: 0,
        frameCounter: 0,
        okCount: 0,
        jumpCount: 0,

        start: function() {
            this.running = true;
            //this.currentGoalIndex = 0;
            console.log('AutoPilot: ON');
        },

        stop: function() {
            this.running = false;
            //this.currentGoalIndex = 0;
            this.resetInput();
            console.log('AutoPilot: OFF');
        },

        toggle: function() {
            if (this.running) {
                this.stop();
            } else {
                this.start();
            }
        },

        update: function(player) {
            this.resetInputExceptCursor();
            if (this.frameCounter % 5 === 0) {
                if ($gameMessage.isBusy()) {
                    // メッセージが表示されている場合、pagedownキーを押し続ける
                    Input._currentState['pagedown'] = true;
                } else if ($gameMap.isEventRunning()) {
                    // メッセージ表示を伴わないイベント実行中には何も操作しない
                    Input._currentState['ok'] = true;
                } else if (this.jumpCount > 0) {
                    Math.floor(Math.random()*8) === 0 ? this.randomMove(player) : this.simulateKeyPress(player.direction());
                    this.jumpCount--;
                } else {
                    this.resetInput();
                    const goalEvent = this.findNextGoalEvent();
                    const enemyEvent = this.findNearbyEnemy(player);
                    const chestEvent = this.findNearbyChest(player);

                    if (enemyEvent) {
                        this.fightEnemy(player, enemyEvent);
                    } else if (chestEvent) {
                        this.openChest(player, chestEvent);
                    } else if (goalEvent) {
                        if (this.reachedGoal(player, goalEvent)) {
                            this.currentGoalIndex++;
                        } else {
                            Math.floor(Math.random()*8) === 0 ? this.randomMove(player) : this.moveToGoal(player, goalEvent);
                        }
                    } else {
                        this.randomMove(player);
                        this.stop();
                    }
                }
            }

            this.frameCounter++;
        },

        resetInput: function() {
            Input._currentState['pagedown'] = false;
            Input._currentState['attack'] = false;
            Input._currentState['cancel'] = false;
            Input._currentState['ok'] = false;
            Input._currentState['up'] = false;
            Input._currentState['down'] = false;
            Input._currentState['left'] = false;
            Input._currentState['right'] = false;
        },

        resetInputExceptCursor: function() {
            Input._currentState['pagedown'] = false;
            Input._currentState['attack'] = false;
            Input._currentState['cancel'] = false;
        },

        findNextGoalEvent: function() {
            const goalEvents = $gameMap.events().filter(event => event.event().meta.autoPilotGoal)
                .sort((a, b) => Number(a.event().meta.autoPilotGoal) - Number(b.event().meta.autoPilotGoal));
            
            return goalEvents[this.currentGoalIndex] || null;
        },

        reachedGoal: function(player, goalEvent) {
            const dx = Math.abs(goalEvent.x - player.x);
            const dy = Math.abs(goalEvent.y - player.y);
            return dx <= 1 && dy <= 1;
        },

        findNearbyEnemy: function(player) {
            const thresholdDistance = 4; // チェックする範囲
            const events = $gameMap.events();
            return events.find(event => {
                const dx = Math.abs(event.x - player.x);
                const dy = Math.abs(event.y - player.y);
                return dx <= thresholdDistance && dy <= thresholdDistance && event.event().meta.ABSenemy && !event.ABSdefeated;
            });
        },

        findNearbyChest: function(player) {
            const thresholdDistance = 6; // チェックする範囲
            const events = $gameMap.events();
            return events.find(event => {
                const dx = Math.abs(event.x - player.x);
                const dy = Math.abs(event.y - player.y);
                return dx <= thresholdDistance && dy <= thresholdDistance && event.event().meta.treasure && !event.isOpenedChest;
            });
        },

        fightEnemy: function(player, enemy) {
            const thresholdDistance = 1.5;
            const dx = Math.abs(enemy.x - player.x);
            const dy = Math.abs(enemy.y - player.y);
            if (dx <= thresholdDistance && dy <= thresholdDistance) {
                Math.floor(Math.random()*8) === 0 ? this.randomMove(player) : this.simulateKeyPress(10-(player.findDirectionTo(enemy.x, enemy.y)));
            } else {
                Math.floor(Math.random()*8) === 0 ? this.randomMove(player) : player.turnTowardCharacter(enemy);
                Math.floor(Math.random()*8) === 0 ? Input._currentState['attack'] = true : this.simulateKeyPress(player.findDirectionTo(enemy.x, enemy.y));
                if (this.isTileTag2(player)) {
                    // 地形タグが2の場合はジャンプ
                    this.jumpOverObstacle(player, player.direction());   
                }
            }
        },

        openChest: function(player, chest) {
            const thresholdDistance = 1;
            const dx = Math.abs(chest.x - player.x);
            const dy = Math.abs(chest.y - player.y);
            if (dx <= thresholdDistance && dy <= thresholdDistance) {
                player.turnTowardCharacter(chest);
                if (Input._currentState['ok'] === false) {
                    this.okCount++;
                    if (this.okCount > 8) {
                        Input._currentState['ok'] = true;
                        this.okCount = 0;
                    }
                } else {
                    this.okCount++;
                    if (this.okCount > 8) {
                        Input._currentState['ok'] = false;
                        this.okCount = 0;
                    }
                }
            } else {
                if (this.isTileTag2(player)) {
                    // 地形タグが2の場合はジャンプ
                    this.jumpOverObstacle(player, player.direction());   
                } else {
                    this.simulateKeyPress(player.findDirectionTo(chest.x, chest.y));
                }
            }
        },

        moveToGoal: function(player, goalEvent) {
            const direction = player.findDirectionTo(goalEvent.x, goalEvent.y);

            if (!player.isMoving() && this.isTileTag2(player)) {
                // 地形タグが2の場合はジャンプ
                    this.jumpOverObstacle(player, direction);   
            } else if (direction > 0) {
                const steps = Math.random() < 0.5 ? 1 : 2; // ランダムに1歩または2歩進む
                for (let i = 0; i < steps; i++) {
                    this.simulateKeyPress(direction);
                    //this.simulateKeyPress(direction);
                }
                this.clearStuckCounter();
            } else {
                this.handleStuckSituation(player);
            }
        },

        isTileTag2: function(player) {
            const x1 = $gameMap.roundXWithDirection(Math.floor(player.x), player.direction());
            const y1 = $gameMap.roundYWithDirection(Math.floor(player.y), player.direction());
            const x2 = $gameMap.roundXWithDirection(Math.ceil(player.x), player.direction());
            const y2 = $gameMap.roundYWithDirection(Math.ceil(player.y), player.direction());
            return $gameMap.terrainTag(x1, y1) === 2 || $gameMap.terrainTag(x1, y2) === 2 || $gameMap.terrainTag(x2, y1) === 2 || $gameMap.terrainTag(x2, y2) === 2;
        },

        jumpOverObstacle: function(player, direction) {
            Input._currentState['cancel'] = true;
            this.simulateKeyPress(direction);
            this.jumpCount = 40;
            //player.jump(0, 2);
        },

        randomMove: function(player) {
            const directions = [2, 4, 6, 8];
            const direction = directions[Math.floor(Math.random() * directions.length)];
            this.simulateKeyPress(direction);
        },

        simulateKeyPress: function(direction) {
            switch (direction) {
                case 2:
                    Input._currentState['down'] = true; Input._currentState['up'] = false;
                    break;
                case 4:
                    Input._currentState['left'] = true; Input._currentState['right'] = false;
                    break;
                case 6:
                    Input._currentState['right'] = true; Input._currentState['left'] = false;
                    break;
                case 8:
                    Input._currentState['up'] = true; Input._currentState['down'] = false;
                    break;
            }
        },

        handleStuckSituation: function(player) {
            if (!this.stuckCounter) {
                this.stuckCounter = 0;
            }
            this.stuckCounter++;

            if (this.stuckCounter > 60) {
                this.randomMove(player);
                this.stuckCounter = 0;
            }
        },

        clearStuckCounter: function() {
            this.stuckCounter = 0;
        }
    };

    // マップ開始時に自動操縦を開始
    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function() {
        _Scene_Map_start.call(this);
        window.autoPilot.currentGoalIndex = 0;
        //window.autoPilot.start();
    };

    // マップ終了時に自動操縦を停止
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function() {
        _Scene_Map_terminate.call(this);
        window.autoPilot.stop();
    };

    // 自動操縦のON/OFFを切り替え
    const _Input_update = Input.update;
    Input.update = function() {
        _Input_update.call(this);
        return;
        if (this.isTriggered('tab')) {
            window.autoPilot.toggle();
        }
    };
})();
