/*:
 * @target MZ
 * @plugindesc 汎用エラーハンドリングプラグイン。エラーをキャッチしてゲームを停止せずに処理を続行します。
 * @author YourName
 * @help
 * ゲーム内で発生したJavaScriptエラーをキャッチし、ゲームの動作を停止させずに
 * エラーメッセージをコンソールとアラートで表示します。
 */

(function() {
    // グローバルエラーハンドリング関数を定義
    window.handleError = function(error) {
        // コンソールにエラーメッセージを表示
        console.error("エラー発生: ", error.message);
        console.error(error.stack);

        // プレイヤーにエラー通知（開発用に変更可）
        alert("予期しないエラーが発生しました。詳細はコンソールで確認できます。");

        // ゲームを停止せず、続行させるためにtrueを返す
        return true;
    };

    // JavaScriptエラーをグローバルに捕捉するためにエラーハンドラを設定
    window.onerror = function(message, source, lineno, colno, error) {
        // エラーオブジェクトをhandleError関数で処理
        return window.handleError(error);
    };

    // スクリプト内でtry-catchを使って個別にエラーハンドリング
    var originalUpdate = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        try {
            originalUpdate.call(this);
        } catch (e) {
            window.handleError(e); // エラーをハンドルしてゲームを止めない
        }
    };
})();
