/*:
 * @target MZ
 * @plugindesc plugins.jsから全プラグインのパラメータをJSONファイルに展開する抽出プラグイン
 * @author you
 *
 * @help
 * このプラグインは開発用です。
 * プラグインをONにしてテストプレイを起動すると、
 * plugins.jsの内容をもとに各プラグインのパラメータを
 * data/params_override/PluginName.json に出力します。
 *
 * デプロイ時にはOFFにしてください。
 */

(() => {
  if (!Utils.isNwjs()) return;
  if (!Utils.isOptionValid("test")) return;

  const fs = require("fs");
  const path = require("path");
  const baseDir = path.join("data", "params_override");

  // フォルダがなければ作成
  if (!fs.existsSync(baseDir)) {
    fs.mkdirSync(baseDir, { recursive: true });
  }

  const plugins = $plugins; // plugins.jsの内容そのもの

  for (const plugin of plugins) {
    const name = plugin.name;
    const params = plugin.parameters || {};
    const file = path.join(baseDir, `${name}.json`);

    try {
      fs.writeFileSync(file, JSON.stringify(params, null, 2), "utf8");
      console.log(`[ParamDumper] Wrote: ${file}`);
    } catch (e) {
      console.error(`[ParamDumper] Failed to write ${file}: ${e}`);
    }
  }
})();
