"use strict";
/*:
 * @target MZ
 * @plugindesc [DevTool] イベント情報オーバーレイ（軽量・動的生成）v2.0
 *
 * @help
 * Tabキーを2回押すと表示ON/OFFが切り替わります。
 * - 表示中のみ処理が動作します（OFF中は完全停止）
 * - 画面内にいるイベントのみ表示され、スクロール対応
 * - 透明・画像なしイベントも対象
 * - 描画は動的生成＋動的破棄で軽量
 */

(() => {
  const FRAME_SKIP = 3;
  const SCREEN_WIDTH = 1108;
  const SCREEN_HEIGHT = 624;

  const customEvaluators = [
    e => $gameMap.regionId(e.x, e.y),
    e => e.event().meta.debugFlag || ""
  ];

  let overlayVisible = false;
  let tabPressCount = 0;

  Input.keyMapper[9] = "tab";

  class Sprite_EventOverlay extends Sprite {
    constructor(event) {
      super();
      this._event = event;
      this._bitmap = new Bitmap(200, 96);
      this._bitmap.fontFace = "mplus-1m-regular";
      this._bitmap.fontSize = 10;
      this._bitmap.outlineWidth = 3;
      this._bitmap.outlineColor = "rgba(0, 0, 0, 0.8)";
      this._bitmap.paintOpacity = 192;
      this._textSprite = new Sprite(this._bitmap);
      this._textSprite.opacity = 192;
      this.addChild(this._textSprite);
      this.anchor.set(0.5, 2.4);
      this._lastText = "";
      this._frameCount = 0;
    }

    update() {
      if (++this._frameCount % FRAME_SKIP !== 0) return;

      const ev = this._event;
      const sx = ev.screenX();
      const sy = ev.screenY();

      this.x = sx;
      this.y = sy - 32;

      const mapId = $gameMap.mapId();
      const id = ev.eventId();
      const name = ev.event().name;
      const meta = ev.event().meta;
      const ss = ["A", "B", "C", "D"].filter(c => $gameSelfSwitches.value([mapId, id, c])).join(" ");
      const customs = customEvaluators.map(fn => {
        try {
          return fn(ev);
        } catch (e) {
          return "[err]";
        }
      }).filter(v => v !== "");

      const metaLines = Object.entries(meta).map(([k, v]) => `${k}: ${v}`);
      const lines = [
        `● ID: ${id}`,
        `Name: ${name}`,
        ...metaLines,
        `SelfSwitches: ${ss}`,
        ...customs.map((v, i) => `Eval${i + 1}: ${v}`)
      ];

      const joined = lines.join("\n");
      const color = (joined !== this._lastText) ? 14 : 0;
      this._bitmap.clear();
      this._bitmap.textColor = ColorManager.textColor(color);
      lines.forEach((line, i) => {
        this._bitmap.drawText(line, 0, i * 12, 200, 12, 'left');
      });

      this._lastText = joined;
    }
  }

  const _Spriteset_Map_createLowerLayer = Spriteset_Map.prototype.createLowerLayer;
  Spriteset_Map.prototype.createLowerLayer = function() {
    _Spriteset_Map_createLowerLayer.call(this);
    this._eventOverlayContainer = new Sprite();
    this._eventOverlayMap = {}; // eventId -> Sprite
    this.addChild(this._eventOverlayContainer);
  };

  const _Spriteset_Map_update = Spriteset_Map.prototype.update;
  Spriteset_Map.prototype.update = function() {
    _Spriteset_Map_update.call(this);
    if (!overlayVisible) return;

    const left = -32;
    const right = SCREEN_WIDTH + 32;
    const top = -32;
    const bottom = SCREEN_HEIGHT + 32;

    const currentIds = new Set();

    for (const ev of $gameMap.events()) {
      const id = ev.eventId();
      const sx = ev.screenX();
      const sy = ev.screenY();
      const inView = sx >= left && sx <= right && sy >= top && sy <= bottom;
      if (!inView) continue;

      currentIds.add(id);

      if (!this._eventOverlayMap[id]) {
        const sprite = new Sprite_EventOverlay(ev);
        this._eventOverlayMap[id] = sprite;
        this._eventOverlayContainer.addChild(sprite);
      }
      this._eventOverlayMap[id].visible = true;
      this._eventOverlayMap[id].update();
    }

    // 消えたイベントの削除
    for (const idStr of Object.keys(this._eventOverlayMap)) {
      const id = Number(idStr);
      if (!currentIds.has(id)) {
        const sprite = this._eventOverlayMap[id];
        this._eventOverlayContainer.removeChild(sprite);
        delete this._eventOverlayMap[id];
      }
    }
  };

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _Scene_Map_update.call(this);

    if (Input.isTriggered("tab")) {
      tabPressCount++;
    } else if (tabPressCount >= 2) {
      overlayVisible = !overlayVisible;
      tabPressCount = 0;

      if (!overlayVisible && SceneManager._scene._spriteset) {
        const overlays = SceneManager._scene._spriteset._eventOverlayMap;
        const container = SceneManager._scene._spriteset._eventOverlayContainer;
        for (const id in overlays) {
          container.removeChild(overlays[id]);
        }
        SceneManager._scene._spriteset._eventOverlayMap = {};
      }
    }
  };

})();
