//=============================================================================
// Koke_CustomItemWindow.js
//=============================================================================

/*:
 * @plugindesc アイテム画面改造プラグイン
 * @author koke
 */


(function() {
'use strict';

Window_ItemCategory.prototype.initialize = function() {
    var x = Graphics.width / 4;
    Window_HorzCommand.prototype.initialize.call(this, x, 0);
};

Window_ItemCategory.prototype.windowWidth = function() {
    return Graphics.boxWidth / 2;
};

Window_ItemCategory.prototype.maxCols = function() {
    return 2;
};

Window_ItemCategory.prototype.makeCommandList = function() {
    this.addCommand(TextManager.item,    'item');
//    this.addCommand(TextManager.weapon,  'weapon');
//    this.addCommand(TextManager.armor,   'armor');
    this.addCommand(TextManager.keyItem, 'keyItem');
};

Window_ItemList.prototype.initialize = function(x, y, width, height) {
    if (x >= 0) {
        var wx = x;
    } else {
        var wx = Graphics.width / 4;
    };
    if (width >= 0) {
        var wwidth = width;
    } else {
        var wwidth = Graphics.boxWidth　/ 2;
    };
    Window_Selectable.prototype.initialize.call(this, wx, y, wwidth, height);
    this._category = 'none';
    this._data = [];
};

Window_ItemList.prototype.maxCols = function() {
    return 1;
};

// Scene_Item.prototype.create = function() {
//     Scene_ItemBase.prototype.create.call(this);
//     this.createKokeHelpWindow();
//     this.createCategoryWindow();
//     this.createItemWindow();
//     this.createActorWindow();
// };

// Scene_Item.prototype.createKokeHelpWindow = function() {
//     this._helpWindow = new Window_Help(this,1,1);
//     this.addWindow(this._helpWindow);
// };

// Scene_Item.prototype.createCategoryWindow = function() {
//     this._categoryWindow = new Window_ItemCategory();
//     this._categoryWindow.setHelpWindow(this._helpWindow);
//     this._categoryWindow.y = this._helpWindow.height;
//     this._categoryWindow.setHandler('ok',     this.onCategoryOk.bind(this));
//     this._categoryWindow.setHandler('cancel', this.popScene.bind(this));
//     this.addWindow(this._categoryWindow);
// };

Scene_Item.prototype.createItemWindow = function() {
    var wy = this._categoryWindow.y + this._categoryWindow.height;
    var wh = Graphics.boxHeight - wy;
    this._itemWindow = new Window_ItemList(Graphics.width / 4, wy, Graphics.boxWidth　/ 2, wh);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
    this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
    this.addWindow(this._itemWindow);
    this._categoryWindow.setItemWindow(this._itemWindow);
};

})();