import sys
from PIL import Image
import os

def process_image(file_path):
    # 画像を開く
    with Image.open(file_path) as img:
        # 元の画像サイズを取得
        width, height = img.size
        
        # 画像を半分に縮小
        img = img.resize((width // 2, height // 2), Image.LANCZOS)
        
        # 縮小後の新しいサイズを取得
        new_width, new_height = img.size
        
        # 新しい画像サイズを計算（余白を追加）
        final_width = new_width + 144  # 左右に72pxずつ追加
        final_height = new_height + 222  # 下に222px追加
        
        # 新しい透明な画像を作成
        new_img = Image.new('RGBA', (final_width, final_height), (0, 0, 0, 0))
        
        # 縮小した画像を新しい画像の中央上部に貼り付け
        new_img.paste(img, (72, 0))
        
        # 新しいファイル名を生成
        directory, filename = os.path.split(file_path)
        new_filename = f"${filename}"
        new_file_path = os.path.join(directory, new_filename)
        
        # 新しい画像を保存
        new_img.save(new_file_path)
        print(f"Processed and saved: {new_file_path}")

def main():
    if len(sys.argv) < 2:
        print("Usage: python script.py <image_file1> <image_file2> ...")
        return
    
    for file_path in sys.argv[1:]:
        if os.path.isfile(file_path):
            process_image(file_path)
        else:
            print(f"File not found: {file_path}")

if __name__ == "__main__":
    main()
