/*:
 * @target MZ
 * @plugindesc バトル中、指定したアクターがダメージを受けたりHP回復魔法を受けたときにスイッチをONにします
 *
 * @author スタジオVR
 *
 * @param actorSwitchPairs
 * @text アクターとスイッチのペア
 * @desc アクターとスイッチのペアのリスト。アクターがダメージを受けたりHP回復魔法を受けたときに対応するスイッチがONになります。
 * @type struct<ActorSwitchPair>[]
 * @default []
 *
 * @help ActorDamageSwitch.js
 *
 * バトル中、指定したアクターがダメージを受けたりHP回復魔法を受けた場合、指定したスイッチをONにするプラグインです。
 */
/*~struct~ActorSwitchPair:
 * @param targetActorId
 * @text 対象アクター番号
 * @desc ダメージを受けたりHP回復魔法を受けた場合にスイッチをONにする対象のアクター番号
 * @type number
 * @default 1
 *
 * @param switchId
 * @text 指定スイッチ
 * @desc アクターがダメージを受けたりHP回復魔法を受けた場合にONにするスイッチの番号
 * @type switch
 * @default 1
 */
(() => {
  const parameters = PluginManager.parameters("ActorDamageSwitch");
  const actorSwitchPairs = JSON.parse(parameters["actorSwitchPairs"]).map(pair => JSON.parse(pair));

  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    if (target.isActor()) {
      const prevHp = target.hp;
      _Game_Action_apply.call(this, target);
      const hpChange = target.hp - prevHp;

      if (hpChange !== 0) {
        actorSwitchPairs.forEach(pair => {
          if (target.actorId() === Number(pair.targetActorId)) {
            $gameSwitches.setValue(Number(pair.switchId), true);
          }
        });
      }
    } else {
      _Game_Action_apply.call(this, target);
    }
  };
})();
