/*:
 * @plugindesc Check Lead Actor and Toggle Switch
 * @author スタジオVR
 *
 * @param actorSwitchPairs
 * @text Actor-Switch Pairs
 * @desc List of actor and switch ID pairs
 * @type struct<ActorSwitchPair>[]
 * @default []
 *
 * @help
 * This plugin checks if the specified actor is the lead party member when the battle starts.
 * If so, it turns ON the corresponding switch.
 */

/*~struct~ActorSwitchPair:
 * @param actorId
 * @text Actor ID
 * @desc The ID of the actor to check as the lead party member
 * @type number
 * @min 1
 * @default 1
 *
 * @param switchId
 * @text Switch ID
 * @desc The ID of the switch to toggle ON when the specified actor is the lead party member
 * @type number
 * @min 1
 * @default 551
 */

(() => {
    const parameters = PluginManager.parameters('CheckLeadActorAndToggleSwitch');
    const actorSwitchPairs = JSON.parse(parameters['actorSwitchPairs'] || '[]').map(pair => {
        const parsedPair = JSON.parse(pair);
        parsedPair.actorId = Number(parsedPair.actorId);
        parsedPair.switchId = Number(parsedPair.switchId);
        return parsedPair;
    });

    const _Scene_Battle_start = Scene_Battle.prototype.start;
    Scene_Battle.prototype.start = function() {
        _Scene_Battle_start.call(this);
        const leaderId = $gameParty.leader().actorId();
        const targetPair = actorSwitchPairs.find(pair => pair.actorId === leaderId);

        actorSwitchPairs.forEach(pair => {
            if (pair === targetPair) {
                $gameSwitches.setValue(pair.switchId, true);
            } else {
                $gameSwitches.setValue(pair.switchId, false);
            }
        });
    };
})();
