/*:
 * @target MZ
 * @plugindesc 敵撃破時に変数に数値を加算するプラグイン
 * @author スタジオVR
 *
 * @param rules
 * @text ルールリスト
 * @desc 敵が撃破されたときに適用されるルールのリストです。
 * @type struct<Rule>[]
 * @default []
 */

/*~struct~Rule:
 * @param targetedEnemies
 * @text 特定の敵
 * @desc 変数に数値を加算する対象の敵のIDをカンマ区切りで指定します。
 * @type string
 * @default 1,2,3
 *
 * @param targetedVariable
 * @text 特定の変数
 * @desc 敵を撃破したときに加算される変数のIDを指定します。
 * @type number
 * @default 1
 *
 * @param valueToAdd
 * @text 加算する値
 * @desc 敵が撃破されたときに変数に加算される値を指定します。
 * @type number
 * @default 1
 */

(() => {
  const pluginName = 'EnemyDefeatedVariableAddition';
  const parameters = PluginManager.parameters(pluginName);
  const rules = JSON.parse(parameters.rules || '[]').map(rule => {
    const parsedRule = JSON.parse(rule);
    parsedRule.targetedEnemies = parsedRule.targetedEnemies.split(',').map(Number);
    parsedRule.valueToAdd = Number(parsedRule.valueToAdd);
    return parsedRule;
  });

  const _Game_Enemy_performCollapse = Game_Enemy.prototype.performCollapse;
  Game_Enemy.prototype.performCollapse = function() {
    _Game_Enemy_performCollapse.call(this);

    for (const rule of rules) {
      if (rule.targetedEnemies.includes(this.enemyId())) {
        const currentValue = $gameVariables.value(rule.targetedVariable);
        $gameVariables.setValue(rule.targetedVariable, currentValue + rule.valueToAdd);
      }
    }
  };
})();
