var Victor = Victor || {};
Victor.TrackTroop = Victor.TrackTroop|| {};

var Imported = Imported || {};
Imported.TrackTroop = "TrackTroop";
/*:
* @target MZ
* @plugindesc This plugin allows setting a different music track for specific troop IDs
* @author inVictor || Version 1.0.0
* @help
*
* This plugin allows setting a different music track for specific troop IDs 
* on both RPG Maker MV and MZ.
*
* Special thanks to Dairnon, TheoAllen and the LunaTechs
*
* @param troopAudioList
* @text Troop Audio List
* @desc Select the troop and its respective audio file
* @type struct<audio>[]
* @default false

 */

/*~struct~audio:
*
* @param troopIDRange
* @text Troop ID Range
* @type string
* @desc Specify the range of troop IDs to change the battle BGM. (e.g. 3-5)
*
* @param audioFile
* @text AudioFile
* @type file
* @dir audio/bgm/
*
* */

($=> {
    
    var JSONSuperParse = function (string) {
    var temp;
    try {
        temp = JsonEx.parse(typeof string === 'object' ? JsonEx.stringify(string) : string);
    } catch (e) {
        return string;
    }
    if (typeof temp === 'object') {
        Object.keys(temp).forEach(function (key) {
            temp[key] = JSONSuperParse(temp[key]);
            if (temp[key] === '') {
                temp[key] = null;
            }
        });
    }
    return temp;
    };

    var parameters = JSONSuperParse(PluginManager.parameters('INV_TrackTroop'));
	
//Battle BGM depending on Troop ID
const Alias_battleBgm = $.battleBgm;
$.battleBgm = function() {
   var id = $gameTroop._troopId;
   var foundtroop =
   parameters.troopAudioList.find(e=> {
      var range = e.troopIDRange.split("-");
      if (id >= Number(range[0]) && id <= Number(range[1])) {
         return e;
      }
   });
   if (foundtroop) return this.bossTheme(foundtroop.audioFile);
   return Alias_battleBgm.apply(this, arguments);
};

// Boss theme info    
$.bossTheme = function(audioFile) {
    var boss = {};
    boss.name = audioFile;
    boss.pan = 0;
    boss.pitch = 100;
    boss.volume = 100;
    return boss;
};
})(Game_System.prototype);