// --------------------------------------------------------------------------
// 
// InputDialog.js
//
// Copyright (c) kotonoha*
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//
// 2023/04/12 ver1.0 プラグイン公開
// 2024/08/07 ver1.1 スタジオVR:キャンセル時の戻り値を-1に変更
// 2024/08/07 ver1.2 スタジオVR:デフォルト値を削除し、初期値用の変数IDを追加
// 
// --------------------------------------------------------------------------
/*:
 * @target MZ
 * @plugindesc キーボードで文字を入力し、入力内容を変数に格納するプラグイン
 * @author kotonoha*
 *
 * @command openDialog
 * @text テキスト入力を表示
 * @desc テキスト入力ウィンドウを表示します。
 *
 * @arg varId
 * @text 変数ID (結果)
 * @desc 入力されたテキストを格納する変数ID
 * @type variable
 * @default 1
 *
 * @arg defaultVarId
 * @text 変数ID (初期値)
 * @desc 入力欄に表示する初期値が格納されている変数ID
 * @type variable
 * @default 2
 *
 * @arg defaultText
 * @text メッセージ
 * @desc テキスト入力を促すメッセージを指定します。
 * @default Please enter your text.
 *
 * @help
 * プラグインコマンドで「InputDialog」を選び、結果を格納する変数ID・初期値が格納されている変数ID・メッセージをそれぞれ設定してください。
 * キーボード上で文字入力が可能になります。入力した文字は指定した変数ID（結果）に入ります。
 * 空入力の場合は空文字列('')が入ります。キャンセルの場合は -1 が入ります。
 * 
 */
(() => {
  
  const pluginName = 'InputDialog';
  PluginManager.registerCommand(pluginName, 'openDialog', args => {
    const varId = Number(args.varId);
    const defaultVarId = Number(args.defaultVarId);
    const defaultText = args.defaultText;
    const defaultValue = $gameVariables.value(defaultVarId);
    const text = window.prompt(defaultText, defaultValue);
    if (text === null) {
      $gameVariables.setValue(varId, -1);
    } else {
      $gameVariables.setValue(varId, text);
    }
  });
})();