//=============================================================================
// PANDA_ConvertDataName.js
//=============================================================================
// [Update History]
// 2020-08-22 Ver.1.0.0 First Release for MV/MZ.
// 2020-09-06 Ver.1.0.1 Added the Korean Description.

/*:
 * @target MV MZ
 * @plugindesc show the name and icon of item, skill or enemy etc. in messages.
 * @author panda(werepanda.jp)
 * @url http://www.werepanda.jp/blog/20200822124150.html
 * 
 * @help [How to Use]
 * Replace the following escape characters with their names in messages.
 *  \class[n]  : Class name of ID = n
 *  \skill[n]  : Skill name of ID = n
 *  \item[n]   : Item name of ID = n
 *  \weapon[n] : Weapon name of ID = n
 *  \armor[n]  : Armor name of ID = n
 *  \enemy[n]  : Enemy name of ID = n
 *  \troop[n]  : Troop name of ID = n
 *  \state[n]  : State name of ID = n
 * 
 * Such as \item[\V[1]], you can use a variable for n.
 * In this case, the name of the item ID 1 is displayed.
 * 
 * Such as \*skill[n], you can display an icon for the skill by adding *.
 * item, weapon, armor, state as the same.
 * class, enemy, troop will not.
 * 
 * [License]
 * this plugin is released under MIT license.
 * https://opensource.org/licenses/mit-license.php
 * 
 * [Reference]
 * ItemNameMsg.js by Sasuke KANNAZUKI
 */

/*:ja
 * @target MV MZ
 * @plugindesc 文章中にアイテムやスキル、敵キャラ等の名前やアイコンを表示します。
 * @author panda(werepanda.jp)
 * @url http://www.werepanda.jp/blog/20200822124150.html
 * 
 * @help ■ 使い方
 * 文章の表示や説明文等で、以下の制御文字をそれぞれの名前に置き換えます。
 *  \class[n]  : n番の職業名
 *  \skill[n]  : n番のスキル名
 *  \item[n]   : n番のアイテム名
 *  \item_desc[n] : n番のアイテム説明
 *  \weapon[n] : n番の武器名
 *  \armor[n]  : n番の防具名
 *  \enemy[n]  : n番の敵キャラ名
 *  \troop[n]  : n番の敵グループ名
 *  \state[n]  : n番のステート名
 * 
 * \item[\V[1]] のように、nに変数を用いることも可能です。
 * この場合、1番の変数に格納されているID番号のアイテム名が表示されます。
 * 
 * \*skill[n] のように*を付けると、そのスキルのアイコンを表示できます。
 * item、weapon、armor、state も同様です。
 * class、enemy、troop は、*を付けてもアイコンは表示されません。
 * 
 * ■ 利用規約
 * このプラグインはMITライセンスで配布されます。
 * ご自由にお使いください。
 * https://opensource.org/licenses/mit-license.php
 * 
 * ■ 参考
 * ItemNameMsg.js by 神無月サスケ様
 */

/*:ko
 * @target MV MZ
 * @plugindesc 텍스트중에 아이템이나 스킬, 적 캐릭터등의 이름과 아이콘을 표시합니다.
 * @author panda(werepanda.jp)
 * @url http://www.werepanda.jp/blog/20200822124150.html
 * 
 * @help [사용법]
 * 텍스트 표시나 설명등에서 이하의 제어문자를 각자의 이름으로 치환합니다.
 *  \class[n]  : n번 직업명
 *  \skill[n]  : n번 스킬명
 *  \item[n]   : n번 아이템명
 *  \weapon[n] : n번 무기명
 *  \armor[n]  : n번 방어구명
 *  \enemy[n]  : n번 적 캐릭터명
 *  \troop[n]  : n번 적 군단명
 *  \state[n]  : n번 상태명
 * 
 * \item[\V[1]] 과 같이 n에 변수를 이용할 수도 있습니다.
 * 이 경우, 1번 변수에 저장되어 있는 ID번호를 가진 아이템명이 표시됩니다.
 * 
 * \*skill[n] 과 같이 *를 붙이면 그 스킬의 아이콘을 표시시킬 수 있습니다.
 * item, weapon, armor, state 도 같습니다.
 * class, enemy, troop 는 *를 붙여도 아이콘은 표시되지 않습니다.
 * 
 * [이용 약관]
 * 이 플러그인은 MIT 라이센스로 공개됩니다.
 * https://opensource.org/licenses/mit-license.php
 * 
 * [참조]
 * ItemNameMsg.js by Sasuke KANNAZUKI 님
 */

(() => {
	'use strict';
	
	const _Window_Base_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
	Window_Base.prototype.convertEscapeCharacters = function(text) {
		
		// Original Processing
		text = _Window_Base_convertEscapeCharacters.call(this, text);
		
		// Convert Data Name and Icon
		text = text.replace(/\x1b(\*)?(class|skill|item|item_desc|item_message1|weapon|weapon_desc|armor|armor_desc|enemy|troop|state|actor_level|actor_profile|actor_message1|actor_message2|actor_message3|actor_message4|actor_message5|actor_message6|actor_message7|actor_message8|actor_message9|actor_message10|actor_message11|actor_message12|actor_message13|actor_message14|actor_message15|actor_message16|actor_message17|actor_message18|actor_message19|actor_message20|actor_message21|actor_message22|actor_message23|actor_message24|actor_message25|actor_message26|actor_message27|actor_message28|actor_message29|actor_message30|actor_class|actor_class_profile|actor_wepon_good|actor_wepon_weak|class_profile|party_class|check_switch|check_variable)\[(\d+)\]/gi, function() {
			var text = '';
			var icon = arguments[1];
			var type = arguments[2].toLowerCase();
			var id = parseInt(arguments[3])
			// get object
			var obj = null;
			if (id >= 1) {
				switch(type) {
					case 'class':
						obj = $dataClasses[id];
						break;
					case 'skill':
						obj = $dataSkills[id];
						break;
					case 'item':
						obj = $dataItems[id];
						break;
					case 'item_desc':
						obj = $dataItems[id];
						break;
					case 'item_message1':
                        obj = $dataItems[id].meta.message1;
                        break;
					case 'weapon':
						obj = $dataWeapons[id];
						break;
					case 'weapon_desc':
						obj = $dataWeapons[id];
						break;
					case 'armor':
						obj = $dataArmors[id];
						break;
					case 'armor_desc':
						obj = $dataArmors[id];
						break;
					case 'enemy':
						obj = $dataEnemies[id];
						break;
					case 'troop':
						obj = $dataTroops[id];
						break;
					case 'state':
						obj = $dataStates[id];
						break;
					case 'actor_level':
						obj = $gameActors.actor(id).level;
						break;
					case 'actor_profile':
						obj = $dataActors[id].profile;
						break;
					case 'actor_message1':
						obj = $dataActors[id].meta.message1;
						break;
					case 'actor_message2':
						obj = $dataActors[id].meta.message2;
						break;
					case 'actor_message3':
						obj = $dataActors[id].meta.message3;
						break;
					case 'actor_message4':
						obj = $dataActors[id].meta.message4;
						break;
					case 'actor_message5':
						obj = $dataActors[id].meta.message5;
						break;
					case 'actor_message6':
						obj = $dataActors[id].meta.message6;
						break;
					case 'actor_message7':
						obj = $dataActors[id].meta.message7;
						break;
					case 'actor_message8':
						obj = $dataActors[id].meta.message8;
						break;
					case 'actor_message9':
						obj = $dataActors[id].meta.message9;
						break;
					case 'actor_message10':
						obj = $dataActors[id].meta.message10;
						break;
					case 'actor_message11':
						obj = $dataActors[id].meta.message11;
						break;
					case 'actor_message12':
						obj = $dataActors[id].meta.message12;
						break;
					case 'actor_message13':
						obj = $dataActors[id].meta.message13;
						break;
					case 'actor_message14':
						obj = $dataActors[id].meta.message14;
						break;
					case 'actor_message15':
						obj = $dataActors[id].meta.message15;
						break;
					case 'actor_message16':
						obj = $dataActors[id].meta.message16;
						break;
					case 'actor_message17':
						obj = $dataActors[id].meta.message17;
						break;
					case 'actor_message18':
						obj = $dataActors[id].meta.message18;
						break;
					case 'actor_message19':
						obj = $dataActors[id].meta.message19;
						break;
					case 'actor_message20':
						obj = $dataActors[id].meta.message20;
						break;
					case 'actor_message21':
						obj = $dataActors[id].meta.message21;
						break;
					case 'actor_message22':
						obj = $dataActors[id].meta.message22;
						break;
					case 'actor_message23':
						obj = $dataActors[id].meta.message23;
						break;
					case 'actor_message24':
						obj = $dataActors[id].meta.message24;
						break;
					case 'actor_message25':
						obj = $dataActors[id].meta.message25;
						break;
					case 'actor_message26':
						obj = $dataActors[id].meta.message26;
						break;
					case 'actor_message27':
						obj = $dataActors[id].meta.message27;
						break;
					case 'actor_message28':
						obj = $dataActors[id].meta.message28;
						break;
					case 'actor_message29':
						obj = $dataActors[id].meta.message29;
						break;
					case 'actor_message30':
						obj = $dataActors[id].meta.message30;
						break;
					case 'actor_class':
						obj = $dataClasses[$dataActors[id].classId].name;
                                                obj = obj.replace(/\\I\[\d+\]/g, '');
						break;
					case 'actor_class_profile':
						obj = $dataClasses[$dataActors[id].classId].description;
						break;
					case 'actor_wepon_good':
						if ($gameActors.actor(id)._equips[7]._itemId != 0) {
							obj = $dataArmors[$gameActors.actor(id)._equips[7]._itemId];
						} else {
							obj = 'なし';
						}
						break;
					case 'actor_wepon_weak':
						if ($gameActors.actor(id)._equips[8]._itemId != 0) {
							obj = $dataArmors[$gameActors.actor(id)._equips[8]._itemId];
						} else {
							obj = 'なし';
						}
						break;
					case 'class_profile':
						obj = $dataClasses[id].description;
						break;
					case 'party_class':
						// N番目のメンバーの職業IDを取得
						var classId = $gameParty.members()[id - 1]._classId;
						obj = $dataClasses[classId];
						break;
					case 'check_switch':
						if ($gameSwitches.value(id)) {
                                                    obj = '\x1bC[18]' + '✔' + '\x1b\C';
                                                } else {
                                                    obj = '　';
                                                }
						break;
					case 'check_variable':
						if (1 <= $gameVariables.value(id)) {
                                                    obj = '\x1bC[18]' + '✔' + '\x1b\C';
                                                } else {
                                                    obj = '　';
                                                }
						break;
				}
			}
			if (obj) {
				// get object name
				if ( type.match(/_desc/)) {
					text = obj.description;
				} else if ( type.match(/actor_wepon/) && (obj != 'なし') ) {
					text = obj.name;
				} else if (type.match(/actor_message/)) {
					text = obj;
				} else if (type.match(/item_message/)) {
					text = obj;
				} else if (type.match(/actor/)) {
					text = obj;
                                } else if (type.match(/check/)) {
                                        text = obj;
				} else if (type.match(/class_profile/)) {
					text = obj;
				} else {
					text = obj.name;
				}
				// get object icon
				if (icon === '*') {
					if (obj != 'なし') {
						switch(type) {
							case 'skill':
							case 'item':
							case 'weapon':
							case 'armor':
							case 'state':
							case 'actor_wepon_good':
							case 'actor_wepon_weak':
								text = "\x1bI[" + obj.iconIndex + "]" + text;
						}
					}
				}
			}
			return text;
		}.bind(this));

		// 再度制御文字の変換を行う
		text = _Window_Base_convertEscapeCharacters.call(this, text);

		return text;
		
	};
	
})();

