/*:
 * @target MZ
 * @plugindesc Random event execution plugin
 * @author X^WIVR
 *
 * @help
 * Plugin Command:
 *   RandomEvent numBranches prob1 prob2 ... probN event1 event2 ... eventN
 *     - execute a random common event based on probability
 *       where numBranches is the number of branches, probi is the probability of branch i,
 *       and eventi is the ID of the common event associated with branch i.
 *
 * Examples:
 *   RandomEvent 3 0.4 0.3 0.3 4 5 6
 *     - executes common event 4 with 40% probability,
 *       common event 5 with 30% probability, and
 *       common event 6 with 30% probability.
 * 
 * @command RandomEvent
 * @text Random Event
 * @desc Execute a random common event based on probability.
 *
 * @arg numBranches
 * @type number
 * @min 1
 * @max 10
 * @default 1
 * @text Number of Branches
 * @desc The number of branches.
 *
 * @arg branches
 * @type struct<branch>[]
 * @default []
 * @text Branches
 * @desc The details of each branch.
 *
 * @arg commonEvents
 * @type common_event[]
 * @text Common Events
 * @desc The common events associated with each branch.
 *
 * @struct branch
 * @text Branch
 * @desc The details of a single branch.
 *
 * @arg probability
 * @type number
 * @min 0
 * @max 1
 * @default 0.5
 * @text Probability
 * @desc The probability of this branch being selected.
 *
 * @typedef common_event
 * @type struct<commonEvent>
 *
 * @struct commonEvent
 * @text Common Event
 * @desc The details of a common event.
 *
 * @arg id
 * @type common_event
 * @text ID
 * @desc The ID of the common event to execute.
 */

(() => {
    "use strict";
    const pluginName = "RandomEvent";
    
    const _Game_Interpreter_pluginCommand =
        Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === pluginName) {
            const numBranches = parseInt(args[0]);
            const branchProbabilities = args.slice(1, numBranches + 1).map(parseFloat);
            const eventNums = args.slice(numBranches + 1).map(arg => parseInt(arg));
            selectRandomEvent(numBranches, branchProbabilities, eventNums);
        }
    };

    PluginManager.registerCommand(pluginName, "RandomEvent", args => {
      const numBranches = parseInt(args.numBranches);
      const branchProbabilities = args.probabilities.map(parseFloat);
      const eventNums = args.events.map(event => parseInt(event));
      selectRandomEvent(numBranches, branchProbabilities, eventNums);
      });
      
      function selectRandomEvent(numBranches, branchProbabilities, eventNums) {
      const sumProbabilities = branchProbabilities.reduce((a, b) => a + b, 0);
      const randomValue = Math.random() * sumProbabilities;
      let probabilitySum = 0;
      let selectedBranch = 0;
      for (let i = 0; i < numBranches; i++) {
      probabilitySum += branchProbabilities[i];
      if (randomValue < probabilitySum) {
      selectedBranch = i;
      break;
      }
      }
      const eventNum = eventNums[selectedBranch];
      $gameTemp.reserveCommonEvent(eventNum);
      }})