/*:
 * @plugindesc Random Skill Plugin for RPG Maker MZ
 * @author スタジオVR
 * 
 * @param randomSkillId
 * @text Random Skill ID
 * @desc The ID of the skill that triggers the random skill effect.
 * @type number
 * @default 1
 *
 * @param messageVariableId
 * @text Message Variable ID
 * @desc The ID of the variable to store the message.
 * @type number
 * @default 1
 *
 * @help This plugin allows enemies to use a random skill with the "<RandomSkill>" tag.
 * In the database, add a "<RandomSkill>" tag to the skills you want to include
 * as potential random skills.
 */

(() => {
  const pluginName = "RandomSkill";
  const parameters = PluginManager.parameters(pluginName);
  const randomSkillId = parseInt(parameters["randomSkillId"]);
  const messageVariableId = parseInt(parameters["messageVariableId"]);

  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    if (this._item.object().id === randomSkillId) {
      const randomSkills = $dataSkills.filter(skill => skill && skill.meta.RandomSkill);
      const randomSkill = randomSkills[Math.floor(Math.random() * randomSkills.length)];
      if (randomSkill) {
        const randomAction = new Game_Action(this.subject());
        randomAction.setSkill(randomSkill.id);
        randomAction.apply(target);

        // 追加: スキル名を変数に格納
        const skillName = randomSkill.name;
        const subjectName = this.subject().name();
        const message = subjectName + "の" + skillName + "が発動した！";
        $gameVariables.setValue(messageVariableId, message);

        // 追加: コモンイベントを実行
        if (randomSkill.effects.some(effect => effect.code === 44)) {
          randomSkill.effects
            .filter(effect => effect.code === 44)
            .forEach(effect => $gameTemp.reserveCommonEvent(effect.dataId));
        }
      }
    } else {
      _Game_Action_apply.call(this, target);
    }
  };
})();
